using System;
using System.Web;
using System.Drawing.Drawing2D;
using System.Drawing;
using System.Collections.Generic;
using System.Drawing.Imaging;
using System.Collections;
using System.Threading;

namespace ImageTemplateNet.Web.Handlers
{
    /// <summary>
    /// Handles Web Requests and generates images from an image template so that 
    /// dynamic parameters can display on an image
    /// </summary>
    public class ImageGenerationHandler : IHttpHandler
    {
        /// <summary>
        /// Called everytime an image is requested
        /// </summary>
        /// <param name="context"></param>
        public void ProcessRequest(HttpContext context)
        {
            TemplateImageGeneratorWorker.Instance.ProcessRequest(context);
        }

        /// <summary>
        /// Yes this handler may be reused
        /// </summary>
        public bool IsReusable
        {
            get
            {
                return true;
            }
        }
    }
}
