using System;
using System.Collections.Generic;
using System.Data;
using System.Configuration;

namespace ImageTemplateNet
{
    /// <summary>
    /// Holds the Config and TemplateElement instances
    /// </summary>
    public class TemplateElementHolder
    {
        #region "Private Variables"
        private ElementConfig m_Config;
        private TemplateElement m_Element;
        private List<TemplateElementHolder> m_ChildElements;
        #endregion

        public TemplateElementHolder(TemplateElement element, ElementConfig config, List<TemplateElementHolder> childElements)
	    {
            this.m_Element = element;
            this.m_Config = config;
            this.m_ChildElements = childElements;
	    }

        public List<TemplateElementHolder> ChildElements
        {
            get
            {
                return m_ChildElements;
            }
        }

        public ElementConfig Config
        {
            get
            {
                return m_Config;
            }
        }

        public TemplateElement Element
        {
            get
            {
                return m_Element;
            }
        }

    }
}