using System;
using System.Data;
using System.Configuration;
using System.Drawing;
using System.Collections.Generic;

namespace ImageTemplateNet
{
    /// <summary>
    /// This class is exteneded to provide the implementation that does the actual work of drawing an image template.
    /// </summary>
    public abstract class TemplateElement
    {
        /// <summary>
        /// Called when the element is being asked to draw its self
        /// </summary>
        /// <param name="context"></param>
        public abstract void Draw(DrawContext context);

        /// <summary>
        /// Calculates the X,Y position and size that this element needs to draw its self.
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public virtual Rectangle GetBounds(DrawContext context)
        {
            return context.ElementConfig.Bounds;
        }
    }

}