using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;


namespace ImageTemplateNet
{
    public interface IRange<T>
    {
        T Start { get; }
        T End { get; }
    }

    public class Range<T> : IRange<T>
    {
        private readonly T start;
        private readonly T end;

        public Range(T start, T end)
        {
            this.start = start;
            this.end = end;
        }

        public T Start
        {
            get { return this.start; }
        }

        public T End
        {
            get { return this.end; }
        }
    }
}
