using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;

namespace ImageTemplateNet
{
    /// <summary>
    /// Used to load the configuration settings that Image Template needs
    /// </summary>
    public class ImageTemplateConfiguration
    {
        #region "Private Variables"
        /// <summary>
        /// 
        /// </summary>
        private String configFilePath;
        /// <summary>
        /// 
        /// </summary>
        private String imageCacheDir;
        /// <summary>
        /// 
        /// </summary>
        private int defaultCacheTimeSeconds;
        #endregion

        public static ImageTemplateConfiguration Instance {
            get {
                ImageTemplateConfiguration obj = (ImageTemplateConfiguration)ConfigurationSettings.GetConfig("imageTemplate");
                return obj;
            }
        }

        public ImageTemplateConfiguration(String configFilePath, String imageCacheDir, String defaultCacheTimeSeconds)
        {
            this.configFilePath = configFilePath;
            this.imageCacheDir = imageCacheDir;
            if (!Int32.TryParse(defaultCacheTimeSeconds,out this.defaultCacheTimeSeconds))
            {
                this.defaultCacheTimeSeconds = 60; // Default to caching for 60 seconds
            }
        }
        
        /// <summary>
        /// The path that the root image template configuration is loaded from
        /// </summary>
        public String ConfigFilePath {
            get {
                return configFilePath;
            }
        }

        /// <summary>
        /// The directory that pre generated images should be cached in
        /// </summary>
        public String ImageCacheDirectoryPath
        {
            get {
                return imageCacheDir;
            }
        }

        /// <summary>
        /// The length of time that an image should be cached for before it is deleted
        /// </summary>
        public int DefaultCacheTimeSeconds
        {
            get {
                return defaultCacheTimeSeconds;
            }
        }
    }
}
