using System;
using System.Data;
using System.Configuration;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;

namespace ImageTemplateNet
{
    /// <summary>
    /// Holds the configuration of an Image Template that has been defined in the image template XML file.
    /// </summary>
    public class ImageTemplate
    {
        #region "Private Variables"
        /// <summary>
        /// 
        /// </summary>
        private string m_Id;
        private int m_Width;
        private int m_Height;
        private Color m_BackgroundColor;
        private ImageFormat m_ImageFormat;
        private GraphicsUnit m_GraphicsUnit = GraphicsUnit.Pixel;
        private float m_Rotation;
        private bool m_IsAnimation;
        private System.IO.DirectoryInfo m_BaseDirectory;
        private System.IO.DirectoryInfo m_ImageDirectory;
        private float m_FrameRate;
        private List<TemplateElementHolder> m_Elements = new List<TemplateElementHolder>();
        #endregion

        #region "Constructors"
        /// <summary>
        /// 
        /// </summary>
        /// <param name="baseDirectory"></param>
        public ImageTemplate(System.IO.DirectoryInfo baseDirectory)
        {
            m_BaseDirectory = baseDirectory;
        }
        #endregion

        #region "Public Properties"

        /// <summary>
        /// 
        /// </summary>
        public System.IO.DirectoryInfo BaseDirectory
        {
            get
            {
                return m_BaseDirectory;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        public System.IO.DirectoryInfo ImageDirectory
        {
            get
            {
                return m_ImageDirectory;
            }
            set 
            {
                m_ImageDirectory = value;
            }
        }

        public List<TemplateElementHolder> Elements
        {
            get 
            {
                return m_Elements;
            }
        }

        public bool IsAnimation
        {
            get
            {
                return m_IsAnimation;
            }
            set
            {
                this.m_IsAnimation = value;
            }
        }

        public float FrameRate
        {
            get
            {
                return m_FrameRate;
            }
            set
            {
                this.m_FrameRate = value;
            }
        }

        /// <summary>
        /// The number of degrees the image should be rotated
        /// </summary>
        public float Rotation
        {
            get
            {
                return m_Rotation;
            }
            set
            {
                this.m_Rotation = value;
            }
        }

        public string Id
        {
            get
            {
                return m_Id;
            }
            set
            {
                this.m_Id = value;
            }
        }


        public GraphicsUnit GraphicsUnit 
        {
            get
            {
                return m_GraphicsUnit;
            }
            set
            {
                this.m_GraphicsUnit = value;
            }
        }

        public ImageFormat ImageFormat
        {
            get
            {
                return m_ImageFormat;
            }
            set
            {
                this.m_ImageFormat = value;
            }
        }

        public int Width
        {
            get
            {
                return m_Width;
            }
            set
            {
                this.m_Width = value;
            }
        }

        public int Height
        {
            get
            {
                return m_Height;
            }
            set
            {
                this.m_Height = value;
            }
        }

        public Color BackgroundColor
        {
            get
            {
                return m_BackgroundColor;
            }
            set
            {
                this.m_BackgroundColor = value;
            }
        }
        #endregion


        public TemplateElementHolder GetElementHolderById(string elementId)
        {
            return GetElementHolderById(Elements, elementId);
        }

        protected TemplateElementHolder GetElementHolderById(List<TemplateElementHolder> elements, string elementId)
        {
            foreach (TemplateElementHolder holder in elements)
            {
                if (holder.Config.Id == elementId)
                {
                    return holder;
                }
                else
                {
                    TemplateElementHolder childHolder = GetElementHolderById(holder.ChildElements, elementId);
                    if (childHolder != null)
                    {
                        return childHolder;
                    }
                }
            }
            return null;
        }

    }
}