using System;
using System.Data;
using System.Configuration;
using System.Drawing.Text;
using System.Drawing;
using System.Collections.Generic;

namespace ImageTemplateNet
{
    public enum TextOverflow
    {
        Clip = 0,
        Expand = 1
    }

    public enum TextContentType
    {
        Basic=0,
        Styled=1
    }

    /// <summary>
    /// Summary description for ImageTemplateConfig
    /// </summary>
    public class TextElementConfig : ElementConfig
    {
        private string m_Text;
        private FontFamily m_FontFamily;
        private float m_FontSize;
        private Color m_ForeColor;
        private StringAlignment m_Alignment = StringAlignment.Near;
        private StringAlignment m_LineAlignment = StringAlignment.Near;
        private TextOverflow m_Overflow;
        private bool m_Bold=false;
        private bool m_Italic=false;
        private bool m_Strikeout=false;
        private bool m_Underline=false;
        private TextContentType m_ContentType;
        private float m_MinimumFontSize = 6;
        private bool m_AutoFit = false;

        public TextElementConfig(ElementConfig parent) : base(parent)
        {
            //
            // TODO: Add constructor logic here
            //
        }


        /// <summary>
        /// If set to "Basic" then the text property just contains text and it is rendered in the specified font.
        /// If set to "Styled" then the text is like this ##bluePen##I am in blue ##redPen##I am in read.  Each time ##xxx## is encountered then the current font is set to that style and the text after is is drawn
        /// </summary>
        public TextContentType ContentType
        {
            get
            {
                return m_ContentType;
            }
            set
            {
                m_ContentType = value;
            }
        }


        public TextOverflow Overflow
        {
            get
            {
                return m_Overflow;
            }
            set
            {
                m_Overflow = value;
            }
        }


        public FontStyle FontStyle
        {
            get
            {
                FontStyle fontStyle = FontStyle.Regular;
                if (m_Bold) {
                    fontStyle = FontStyle.Bold;
                }
                if (m_Italic) {
                    fontStyle |= FontStyle.Italic;
                }
                if (m_Strikeout) {
                    fontStyle |= FontStyle.Strikeout;
                }
                if (m_Underline) {
                    fontStyle |= FontStyle.Underline;
                }
                return fontStyle;
            }
        }

        public bool Bold
        {
            get
            {
                return m_Bold;
            }
            set
            {
                m_Bold = value;
            }
        }

        public bool Italic
        {
            get
            {
                return m_Italic;
            }
            set
            {
                m_Italic = value;
            }
        }

        public bool Strikeout
        {
            get
            {
                return m_Strikeout;
            }
            set
            {
                m_Strikeout = value;
            }
        }

        public bool Underline
        {
            get
            {
                return m_Underline;
            }
            set
            {
                m_Underline = value;
            }
        }

        public StringAlignment LineAlignment
        {
            get
            {
                return m_LineAlignment;
            }
            set
            {
                m_LineAlignment = value;
            }
        }

        public StringAlignment Alignment
        {
            get
            {
                return m_Alignment;
            }
            set
            {
                m_Alignment = value;
            }
        }

        public Color ForeColor
        {
            get
            {
                return m_ForeColor;
            }
            set
            {
                m_ForeColor = value;
            }
        }

        public FontFamily FontFamily
        {
            get
            {
                return m_FontFamily;
            }
            set
            {
                m_FontFamily = value;
            }
        }

        public float FontSize
        {
            get
            {
                return m_FontSize;
            }
            set
            {
                m_FontSize = value;
            }
        }


        public float MinimumFontSize
        {
            get
            {
                return m_MinimumFontSize;
            }
            set
            {
                m_MinimumFontSize = value;
            }
        }

        public bool AutoFit
        {
            get
            {
                return m_AutoFit;
            }
            set
            {
                m_AutoFit = value;
            }
        }

        public string Text
        {
            get
            {
                return m_Text;
            }
            set
            {
                m_Text = value;
            }
        }
         
        public Font Font
        {
            get
            {
                Font font = new Font(m_FontFamily, m_FontSize, FontStyle, GraphicsUnit.Point);
                return font;
            }
        }

        public override ElementConfig Clone()
        {
                          
            TextElementConfig config = new TextElementConfig(ParentElement);
            config.Id = Id;
            config.X = X;
            config.Y = Y;
            config.Width = Width;
            config.Height = Height;
            config.Duration = Duration;
            config.FontFamily = FontFamily;
            config.FontSize = FontSize;
            config.ForeColor = ForeColor;
            config.Alignment = Alignment;
            config.LineAlignment = LineAlignment;
            
            config.Text = Text;
            config.Overflow = m_Overflow;
            // Font Style
            //config.FontStyle = m_FontStyle;
            config.Bold = Bold;
            config.Italic = Italic;
            config.Strikeout = Strikeout;
            config.Underline = Underline;
            // Font Style End
            config.AutoFit = AutoFit;
            config.MinimumFontSize = MinimumFontSize;
            return config;
        }

        public StringFormat GetStringFormat()
        {
            StringFormat stringFormat = new StringFormat();
            stringFormat.Alignment = Alignment;
            stringFormat.LineAlignment = LineAlignment;
            return stringFormat;
        }


    }
}