//using MagickNet;
using System;
using System.Data;
using System.Configuration;
using System.Drawing.Imaging;
using System.Drawing;
using System.Collections.Generic;
using System.IO;

namespace ImageTemplateNet
{
    /// <summary>
    /// This template element can hold other temple elements.  It is used to rotate a bunch of elements or to hold a single
    /// from of an animated gif.  It is also used to add dropshadows or borders
    /// </summary>
    public class PanelTemplateElement : TemplateElement
    {
        #region "Constructors"
        public PanelTemplateElement()
        {
        }
        #endregion

        public override void Draw(DrawContext context)
        {
            PanelElementConfig panelConfig = (PanelElementConfig)context.ElementConfig;
            Rectangle panelSize = context.GetBounds();
            Bitmap bmp = new Bitmap(panelSize.Width, panelSize.Height);
            Graphics g = context.Graphics;

            using (Graphics subG = Graphics.FromImage(bmp))
            {
                foreach (TemplateElementHolder holder in context.ElementChildren)
                {
                    DrawContext subElementContext = new DrawContext(subG, context.Template, panelConfig, holder.Config, holder.ChildElements, context.ImageSize);
                    holder.Element.Draw(subElementContext);
                }
            }

            /*
            Brush b = new SolidBrush(Color.Red);
            Pen p = new Pen(b);
            p.Width = 5;
            p.StartCap = System.Drawing.Drawing2D.LineCap.Round;
            p.PenType = System.Drawing.Drawing2D.PenType.SolidColor;
            p.MiterLimit = 2;
            p.LineJoin = System.Drawing.Drawing2D.LineJoin.Bevel;
            p.EndCap = System.Drawing.Drawing2D.LineCap.Round;
            p.DashStyle = System.Drawing.Drawing2D.DashStyle.Dash;
            //p.DashPattern 
            p.DashOffset = 1;
            p.DashCap = System.Drawing.Drawing2D.DashCap.Flat;
            //p.CustomStartCap 
            //p.CustomEndCap 
            //p.CompoundArray 
            //p.Color = 
            p.Alignment = System.Drawing.Drawing2D.PenAlignment.Inset;
            */

            //g.DrawRectangle(panelConfig, panelSize);

            float angle = 0;
            if (panelConfig.Angle != null)
            {
                if (panelConfig.Angle.Start != panelConfig.Angle.End)
                {
                    // Randomly generate the angle to rotate
                    Random r = new Random(DateTime.Now.Millisecond);
                    angle = (float)(panelConfig.Angle.Start + (r.NextDouble() * panelConfig.Angle.End));

                    if (panelConfig.RandomAngleDirection == RandomAngleDirection.Both && r.Next(100) > 50)
                    {
                        angle = angle * -1;
                    }
                }
                else
                {
                    angle = panelConfig.Angle.Start;
                }
            }

            if (panelConfig.DropShadowX != 0 || panelConfig.DropShadowY != 0)
            {
                int fillX, fillY;
                if (panelConfig.DropShadowX > 0)
                {
                    fillX = panelConfig.DropShadowX;
                }
                else
                {
                    fillX = 0;
                }

                if (panelConfig.DropShadowY > 0)
                {
                    fillY = panelConfig.DropShadowY;
                }
                else
                {
                    fillY = 0;
                }

                // As we are drawing on the parent graphic object we need to make sure we apply the correct offset relative to the parent
                //fillX += context.ElementConfig.X;
                //fillY += context.ElementConfig.Y;

                Rectangle panelRect = new Rectangle(new Point(fillX, fillY), context.ElementConfig.Size);
                Image dropShadow = new Bitmap(panelRect.Width, panelRect.Height);
                Graphics gDropShadow = Graphics.FromImage(dropShadow);

                gDropShadow.FillRectangle(new SolidBrush(panelConfig.DropShadowColor), panelRect);
                // Draw the sub elements resize so you can see the dropshadow
                int drawX,drawY,drawWidth,drawHeight;

                drawWidth = panelRect.Width - Math.Abs(panelConfig.DropShadowX);
                drawHeight = (panelRect.Height - Math.Abs(panelConfig.DropShadowY)) + panelConfig.DropShadowBottomPadding;

                if (panelConfig.DropShadowX >= 0)
                {
                    drawX = 0;
                }
                else
                {
                    drawX = Math.Abs(panelConfig.DropShadowX);
                }

                if (panelConfig.DropShadowY >= 0)
                {
                    drawY = 0;
                }
                else
                {
                    drawY = Math.Abs(panelConfig.DropShadowY);
                }


                // Draw the dropshadow
                gDropShadow.DrawImage(bmp, new Rectangle(drawX, drawY, drawWidth, drawHeight));
                gDropShadow.Dispose();


                //Image img = ImageUtility.RotateImage(bmp, panelConfig.BackgroundColor, panelConfig.Angle);

                Image img = ImageUtility.RotateImage(dropShadow, panelConfig.BackgroundColor, angle);

                // As we are drawing on the parent graphic object we need to make sure we apply the correct offset relative to the parent
                drawX += context.ElementConfig.X;
                drawY += context.ElementConfig.Y;

                g.DrawImage(img,panelConfig.Bounds);// new Rectangle(drawX, drawY, panelConfig.Bounds.Width, panelConfig.Bounds,w));
            }
            else
            {
                Image img = ImageUtility.RotateImage(bmp, panelConfig.BackgroundColor, angle);
                g.DrawImage(img, 0, 0);
            }

            if (panelConfig.BorderWidth > 0) {
                g.DrawRectangle(new Pen(panelConfig.BorderColor, panelConfig.BorderWidth), panelConfig.Bounds);
            }
        }

    }
}