using System;
using System.Data;
using System.Configuration;
using System.Drawing;

namespace ImageTemplateNet
{
    /// <summary>
    /// What to do after resizing
    /// </summary>
    public enum PostRotationEffect {
        Clip= 0,
        ResizeToFit=1
    }

    /// <summary>
    /// 
    /// </summary>
    public enum RandomAngleDirection {
        Single=0,
        Both=1
    }

    /// <summary>
    /// Summary description for ImageTemplateConfig
    /// </summary>
    public class PanelElementConfig : ElementConfig
    {
        private Range<float> m_Angle;
        private PostRotationEffect m_PostRotationEffect;
        private int m_DropShadowX;
        private int m_DropShadowY;
        private int m_DropShadowBottomPadding;
        private Color m_DropShadowColor;
        private int m_BorderWidth;
        private Color m_BorderColor;
        private RandomAngleDirection m_RandomAngleDirection;

        public PanelElementConfig(ElementConfig parent) : base (parent)
        {
            //
            // TODO: Add constructor logic here
            //
        }

        public RandomAngleDirection RandomAngleDirection
        {
            get
            {
                return m_RandomAngleDirection;
            }
            set
            {
                m_RandomAngleDirection = value;
            }
        }

        public Color BorderColor
        {
            get
            {
                return m_BorderColor;
            }
            set
            {
                m_BorderColor = value;
            }
        }

        public int BorderWidth
        {
            get
            {
                return m_BorderWidth;
            }
            set
            {
                m_BorderWidth = value;
            }
        }

        public int DropShadowX
        {
            get
            {
                return m_DropShadowX;
            }
            set
            {
                m_DropShadowX = value;
            }
        }

        public int DropShadowY
        {
            get
            {
                return m_DropShadowY;
            }
            set
            {
                m_DropShadowY = value;
            }
        }

        public int DropShadowBottomPadding
        {
            get
            {
                return m_DropShadowBottomPadding;
            }
            set
            {
                m_DropShadowBottomPadding = value;
            }
        }

        public Color DropShadowColor
        {
            get
            {
                return m_DropShadowColor;
            }
            set
            {
                m_DropShadowColor = value;
            }
        }

        public Range<float> Angle {
            get {
                return m_Angle;
            }
            set {
                m_Angle = value;
            }
        }

        public PostRotationEffect PostRotationEffect
        {
            get
            {
                return m_PostRotationEffect;
            }
            set
            {
                m_PostRotationEffect = value;
            }
        }

        public override ElementConfig Clone()
        {
            PanelElementConfig config = new PanelElementConfig(ParentElement);
            CopyBaseProperties(config);
            config.Duration = Duration;
            config.Angle = Angle;
            config.PostRotationEffect = PostRotationEffect;
            config.DropShadowColor = DropShadowColor;
            config.DropShadowX = DropShadowX;
            config.DropShadowY = DropShadowY;
            config.BorderWidth = BorderWidth;
            config.BorderColor = BorderColor;
            config.DropShadowBottomPadding = DropShadowBottomPadding;
            config.RandomAngleDirection = RandomAngleDirection;
            return config;
        }

    }
}