using System;
using System.Data;
using System.Configuration;
using System.Drawing;

namespace ImageTemplateNet
{
    /// <summary>
    /// Summary description for ImageTemplateConfig
    /// </summary>
    public class ImageElementConfig : ElementConfig
    {
        private string m_ImageUrl;
        private ContentAlignment m_ContentAlignment;
        private System.Windows.Forms.PictureBoxSizeMode m_SizeMode;
        private string[] m_Parameters;
        private string m_ImageDir;
        private string m_DefaultImageUrl;

        public string[] Parameters
        {
            get
            {
                return m_Parameters;
            }
            set
            {
                m_Parameters = value;
            }
        }

        public ImageElementConfig(ElementConfig parent) : base(parent)
        {
            
        }

        public System.Windows.Forms.PictureBoxSizeMode SizeMode
        {
            get
            {
                return m_SizeMode;
            }
            set
            {
                m_SizeMode = value;
            }
        }


        public ContentAlignment ContentAlignment
        {
            get
            {
                return m_ContentAlignment;
            }
            set
            {
                m_ContentAlignment = value;
            }
        }

        [DesignTimePropertyAttribute()]
        public string ImageUrl
        {
            get
            {
                return m_ImageUrl;
            }
            set
            {
                m_ImageUrl = value;
            }
        }

        /// <summary>
        /// If the image generated from the template defined in ImageUrl does not exist then this
        /// image will be shown by the element
        /// </summary>
        [DesignTimePropertyAttribute()]
        public string DefaultImageUrl
        {
            get
            {
                return m_DefaultImageUrl;
            }
            set
            {
                m_DefaultImageUrl = value;
            }
        }

        [DesignTimePropertyAttribute()]
        public string BaseImageDir
        {
            get
            {
                return m_ImageDir;
            }
            set
            {
                m_ImageDir = value;
            }
        }

        public override ElementConfig Clone()
        {
            ImageElementConfig config = new ImageElementConfig(ParentElement);
            CopyBaseProperties(config);
            config.ImageUrl = ImageUrl;
            config.SizeMode = SizeMode;
            config.ContentAlignment = ContentAlignment;
            config.BaseImageDir = BaseImageDir;
            config.DefaultImageUrl = DefaultImageUrl;
            return config;
        }

    }
}