using System;
using System.Drawing;
using System.Collections.Generic;

namespace ImageTemplateNet
{
    /// <summary>
    /// Holds the details of the Graphics object all the elements in the template are drawing onto.
    /// </summary>
    public class DrawContext
    {
        #region "Private Variables"
        /// <summary>
        /// 
        /// </summary>
        private Graphics m_Graphics;
        private ImageTemplate m_Template;
        private ElementConfig m_ElementConfig;
        private ElementConfig m_ParentElement;
        private List<TemplateElementHolder> m_ElementChildren;
        private Size m_ImageSize;
        #endregion

        #region "Public Methods"
        /// <summary>
        /// 
        /// </summary>
        /// <param name="graphics"></param>
        /// <param name="template"></param>
        /// <param name="parentElement"></param>
        /// <param name="elementConfig"></param>
        /// <param name="elementChildren"></param>
        /// <param name="imageSize"></param>
        public DrawContext(Graphics graphics, ImageTemplate template, ElementConfig parentElement, ElementConfig elementConfig, List<TemplateElementHolder> elementChildren, Size imageSize)
        {
            this.m_Graphics = graphics;
            this.m_Template = template;
            this.m_ParentElement = parentElement;
            this.m_ElementConfig = elementConfig;
            this.m_ElementChildren = elementChildren;
            this.m_ImageSize = imageSize;
        }

        public Rectangle GetBounds()
        {
            return m_ElementConfig.GetBounds(m_ImageSize);
        }

        #endregion

        public Size ImageSize
        {
            get
            {
                return m_ImageSize;
            }
        }

        public Graphics Graphics
        {
            get
            {
                return m_Graphics;
            }
        }

        public ImageTemplate Template
        {
            get
            {
                return m_Template;
            }
        }

        public ElementConfig ElementConfig
        {
            get
            {
                return m_ElementConfig;
            }
        }

        public ElementConfig ParentElement
        {
            get
            {
                return m_ParentElement;
            }
        }

        public List<TemplateElementHolder> ElementChildren
        {
            get
            {
                return m_ElementChildren;
            }
        }


    }
}