using System;
using System.Data;
using System.Configuration;

namespace ImageTemplateNet
{
    /// <summary>
    /// Summary description for Dimension
    /// </summary>
    public struct Dimension
    {
        #region "Private Variables"
        private SizeType m_SizeType;
        private int m_Size;
        #endregion
        
        public Dimension(SizeType sizeType, int size){
            m_SizeType = sizeType;
            m_Size = size;
        }

        public Dimension(string value, int defaultSize)
        {
            try
            {
                m_Size = 0;
                m_SizeType = SizeType.Absolute;
                SetValue(value);
            }
            catch (Exception ex)
            {
                m_SizeType = SizeType.Absolute;
                m_Size = defaultSize;
            }
        }

        public Dimension(string value)
        {
            m_Size = 0;
            m_SizeType = SizeType.Absolute;
            SetValue(value);
        }

        public bool IsEmpty
        {
            get
            {
                if (m_Size <= 0)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }

        public string ToString()
        {
            if (m_SizeType == SizeType.Pecentage)
            {
                return m_Size + "%";
            }
            else
            {
                return m_Size.ToString();
            }
        }

        public int GetActualSize(int parentSize)
        {
            if (m_SizeType == SizeType.Pecentage)
            {
                return (int) ( (m_Size/100) * parentSize);
            }
            else
            {
                return m_Size;
            }
        }

        public SizeType SizeType
        {
            get
            {
                return m_SizeType;
            }
            set
            {
                m_SizeType = value;
            }
        }

        public int Size
        {
            get
            {
                return m_Size;
            }
            set
            {
                m_Size = value;
            }
        }

        private void SetValue(string value)
        {
            if (value != null)
            {
                SizeType sizeType = SizeType.Absolute;
                if (value.EndsWith("%"))
                {
                    sizeType = SizeType.Pecentage;
                    value = value.Substring(0, value.Length - 1);
                }
                if (value.Length == 0)
                {
                    throw new ArgumentException("The value '" + value + " does not contain a number");
                }
                else
                {
                    m_Size = Convert.ToInt32(value);
                    m_SizeType = sizeType;
                }
            }
            else
            {
                throw new ArgumentNullException("The value is null");
            }
        }


    }
}