using System;
using System.Drawing;
using System.Windows.Forms;
using System.Timers;
using System.Net;
using System.Xml;
using System.Collections;
using System.Diagnostics;


namespace Flipmind.Drawing
{
    public class HexColor
    {
        ///<summary>
        /// Converts a Hex String representation of a color into a color object
        ///</summary>
        public static Color GetColorFromHex(string hex)
        {
            int total = 0;
            char[] chars = hex.ToCharArray();
            for (int i = 0; i < chars.Length; i++)
            {
                char c = chars[i];
                int col = (chars.Length - i) - 1;
                int charValue;
                if (Char.IsDigit(c))
                {
                    charValue = c - '0';
                }
                else
                { // A,B,C,D,E, or F
                    charValue = (c - 'A') + 10;
                }
                int digitValue = (int)Math.Pow(16, col) * charValue;
                total += digitValue;
            }
            return Color.FromArgb(total);
        }
    }
}