using System;
using System.Data;
using System.Configuration;
using System.Drawing;
using Flipmind.Drawing;

namespace Flipmind.Drawing
{
    /// <summary>
    /// Summary description for ColorUtility
    /// </summary>
    public static class ColorUtility
    {
        /// <summary>
        /// Converts a string given as a Name or Hex value to a Color object
        /// </summary>
        /// <param name="color"></param>
        /// <returns></returns>
        public static Color GetColor(string color)
        {
            Color c = Color.Empty;
            if (!string.IsNullOrEmpty(color))
            {
                if (color.StartsWith("#"))
                {
                    c = HexColor.GetColorFromHex(color);
                }
                else
                {
                    c = Color.FromName(color);
                }
            }
            return c;
        }

    }
}