﻿
function ImageSlideShow(arrImages, imageId, previousControlId, nextControlId) {

   this.pos = 0;
   this.images = arrImages;
   this.img = document.getElementById(imageId);
   this.previousControl = document.getElementById(previousControlId);
   this.nextControl = document.getElementById(nextControlId);
    
   this.previous = function() {
      this.gotoImage(this.pos - 1);
      this.toggleControls();
   }
   
   this.next = function() {
      this.gotoImage(this.pos + 1);
      this.toggleControls();
   }
   
   this.toggleControls = function() {
      if (this.pos == 0) this.previousControl.disabled = true;
      if (this.pos == 1) this.previousControl.disabled = false;
      
      if (this.pos == this.images.length - 2) this.nextControl.disabled = false;
      if (this.pos == this.images.length - 1) this.nextControl.disabled = true;
   }
   
   this.gotoImage = function(i) {
      if (!this.images[0]) return;
      
      var maxPos = this.images.length - 1;
      var vali;
      
      if (i >= maxPos) 
         vali = maxPos;
      else if (i <= 0) 
         vali = 0;
      else 
         vali = i;
      
      this.pos = vali;
      this.img.src = this.images[this.pos];
      
      var altText = new String(this.images[this.pos]);
      
      this.img.alt = altText.substring(altText.lastIndexOf("/") + 1, altText.lastIndexOf("."));
   }
   
   
   //======== Helper functions.
   
   function MM_preloadImages(a) { //v3.0
      var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
      var i,j=d.MM_p.length/*,a=MM_preloadImages.arguments*/; for(i=0; i<a.length; i++)
      if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
   }
   
      
   function addOnLoadEvent(func) {
      var oldonload = window.onload;
      if (typeof window.onload != 'function') {
         window.onload = func;
      } else {
         window.onload = function() {
            if (oldonload) oldonload();
            func();
         }
      }
   }
   
   
   //======== Main
   
   // Display the first image.
   this.gotoImage(0);
   
   // Preload the images.
   addOnLoadEvent(function() {MM_preloadImages(arrImages);});
   
}