using System;
using System.Data;
using System.IO;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;


[assembly: System.Web.UI.WebResource("ImageSlideShow.js", "text/javascript", PerformSubstitution = true)]
namespace ImageSlideShow {

   public class ImageSlideShow : WebControl {

      string path;
      string[] files;

      public ImageSlideShow() : base(HtmlTextWriterTag.Table) { }

      public string ImagesDirectory { get { return path; } set { path = value; } }

      protected override void OnPreRender(EventArgs e) {
         base.OnPreRender(e);

         DataBind();

         try {
            files = Directory.GetFiles(Page.MapPath(path));
         } catch {
            Visible = false;
            return;
         }

         Page.ClientScript.RegisterClientScriptInclude(
            this.GetType(),
            "ImageSlideShow.js",
            Page.ClientScript.GetWebResourceUrl(this.GetType(), "ImageSlideShow.js")
         );

      }

      public override void RenderControl(HtmlTextWriter writer) {

         if (files == null) return;

         RenderBeginTag(writer);

         StringBuilder jsImgs = new StringBuilder();

         for (int i = 0; i < files.Length; i++) {
            jsImgs.Append(String.Format("'{0}'", Page.ResolveUrl(String.Concat(path, "/").Replace("//", "/") + Path.GetFileName(files[i]))));
            if (i < files.Length - 1) jsImgs.Append(", ");
         }

         string varName = "slideShow_" + ClientID;
         string imgName = "img_" + ClientID;
         string prevName = "prev_" + ClientID;
         string nextName = "next_" + ClientID;

         writer.RenderBeginTag(HtmlTextWriterTag.Tr);
         writer.RenderBeginTag(HtmlTextWriterTag.Td);

         writer.WriteBeginTag("img");
         writer.WriteAttribute("id", imgName);
         writer.WriteAttribute("src", "");
         writer.WriteAttribute("alt", "");
         writer.WriteLine(HtmlTextWriter.SelfClosingTagEnd);

         writer.RenderEndTag();
         writer.RenderEndTag();

         if (files.Length > 1) {

            writer.RenderBeginTag(HtmlTextWriterTag.Tfoot);
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            writer.RenderBeginTag(HtmlTextWriterTag.Td);

            writer.WriteBeginTag("button");
            writer.WriteAttribute("id", prevName);
            writer.WriteAttribute("onclick", varName + ".previous(); return false;");
            writer.WriteAttribute("disabled", "disabled");
            writer.Write(HtmlTextWriter.TagRightChar);
            writer.Write("&lt;");
            writer.WriteEndTag("button");

            writer.WriteBeginTag("button");
            writer.WriteAttribute("id", nextName);
            writer.WriteAttribute("onclick", varName + ".next(); return false;");
            writer.Write(HtmlTextWriter.TagRightChar);
            writer.Write("&gt;");
            writer.WriteEndTag("button");

            writer.RenderEndTag();
            writer.RenderEndTag();
            writer.RenderEndTag();

         }

         RenderEndTag(writer);

         writer.WriteBeginTag("script");
         writer.WriteAttribute("type", "text/javascript");
         writer.WriteLine(HtmlTextWriter.TagRightChar);
         writer.WriteLine("//<![CDATA[");

         writer.Write(String.Format("var {0} = new ImageSlideShow([{1}], '{2}', '{3}', '{4}')", new object[] { varName, jsImgs.ToString(), imgName, prevName, nextName }));

         writer.WriteLine("//]]>");
         writer.WriteEndTag("script");
      }

   }

}