Imports Microsoft.VisualBasic
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.Webcontrols
Imports System.Collections.Specialized
Imports System.ComponentModel
Imports System.ComponentModel.Design
Imports System.Security.Permissions

Namespace rw
    <DefaultProperty("SelectParameters"), _
    ParseChildren(True), _
    PersistChildren(False)> _
    Public Class FolderContentsDataSource
        Inherits DataSourceControl

        Private _FolderContentsView As FolderContentsDataSourceView
        Private ReadOnly Property FolderContentsView() As FolderContentsDataSourceView
            Get
                If (_FolderContentsView Is Nothing) Then
                    _FolderContentsView = New FolderContentsDataSourceView(Me, "System")
                End If
                Return _FolderContentsView
            End Get
        End Property

        Private _selectParameters As ParameterCollection

        <PersistenceModeAttribute(PersistenceMode.InnerProperty)> _
        Public ReadOnly Property SelectParameters() As ParameterCollection
            Get
                If (_selectParameters Is Nothing) Then
                    _selectParameters = New ParameterCollection()
                    AddHandler _selectParameters.ParametersChanged, AddressOf OnParametersChanged
                    If (IsTrackingViewState) Then
                        CType(_selectParameters, IStateManager).TrackViewState()
                    End If
                End If
                Return _selectParameters
            End Get
        End Property

        Public Function GetSelectedDirectory() As String
            ' The directory name is passed as a parameter
            If (_selectParameters IsNot Nothing) Then
                Dim Directory As Parameter = _selectParameters("Directory")
                If (Directory IsNot Nothing) Then
                    Dim parameterValues As IOrderedDictionary = _selectParameters.GetValues(Context, Me)
                    Return parameterValues(Directory.Name)
                End If
            End If
            Return "C:\"
        End Function

        Protected Overrides Function GetView(ByVal viewName As String) As System.Web.UI.DataSourceView
            If (String.IsNullOrEmpty(viewName) Or _
                (String.Compare(viewName, "DefaultViewName", True) = 0)) Then
                Return FolderContentsView
            End If
            Throw New ArgumentOutOfRangeException("viewName")
        End Function

        Protected Overrides Function GetViewNames() As System.Collections.ICollection
            Dim names() As String = {"DefaultViewName"}
            Return names
        End Function

        Public Event Selected As FolderContentsDataSourceStatusEventHandler
        Public Sub OnSelected(ByVal e As FolderContentsDataSourceStatusEventArgs)
            RaiseEvent Selected(Me, e)
        End Sub

        Public Event Updated As FolderContentsDataSourceStatusEventHandler
        Public Sub OnUpdated(ByVal e As FolderContentsDataSourceStatusEventArgs)
            RaiseEvent Updated(Me, e)
        End Sub

        Public Event Deleted As FolderContentsDataSourceStatusEventHandler
        Public Sub OnDeleted(ByVal e As FolderContentsDataSourceStatusEventArgs)
            RaiseEvent Deleted(Me, e)
        End Sub

        Protected Overrides Sub LoadViewState(ByVal savedState As Object)
            Dim baseState As Object = Nothing
            If (savedState IsNot Nothing) Then
                baseState = savedState(0)
                If (savedState(1) IsNot Nothing) Then
                    CType(SelectParameters, IStateManager).LoadViewState(savedState(1))
                End If
            End If
            MyBase.LoadViewState(baseState)
        End Sub

        Protected Overrides Sub OnInit(ByVal e As System.EventArgs)
            AddHandler Page.LoadComplete, New EventHandler(AddressOf Me.OnPageLoadComplete)
        End Sub

        Private Sub OnPageLoadComplete(ByVal sender As Object, ByVal e As EventArgs)
            If (_selectParameters IsNot Nothing) Then
                _selectParameters.UpdateValues(Context, Me)
            End If
        End Sub

        Private Sub OnParametersChanged(ByVal sender As Object, ByVal e As EventArgs)
            FolderContentsView.RaiseChangedEvent()
        End Sub

        Protected Overrides Function SaveViewState() As Object
            Dim parameterState(3) As Object
            parameterState(0) = MyBase.SaveControlState()
            If (_selectParameters IsNot Nothing) Then
                parameterState(1) = CType(_selectParameters, IStateManager).SaveViewState()
            End If
            Return parameterState
        End Function

        Protected Overrides Sub TrackViewState()
            MyBase.TrackViewState()
            If (_selectParameters IsNot Nothing) Then
                CType(_selectParameters, IStateManager).TrackViewState()
            End If
        End Sub

    End Class

End Namespace
