Imports Microsoft.VisualBasic
Imports System.IO
Imports System.Data
Imports System.Web.UI
Imports System.ComponentModel
Imports System.Collections

Namespace rw
    Public Class FolderContentsDataSourceView
        Inherits DataSourceView

        Private _owner As FolderContentsDataSource

        Public Sub New(ByVal owner As IDataSource, ByVal viewName As String)
            MyBase.New(owner, viewName)
            _owner = owner
        End Sub

        Public Sub SetViewName(ByVal viewName As String)
            RaiseChangedEvent()
        End Sub

        Protected Overrides Function ExecuteSelect(ByVal arguments As System.Web.UI.DataSourceSelectArguments) As System.Collections.IEnumerable
            Dim dt As New DataTable()
            dt.Columns.Add("Name", System.Type.GetType("System.String"))
            dt.Columns.Add("Size", System.Type.GetType("System.Int64"))
            dt.Columns.Add("Modified", System.Type.GetType("System.DateTime"))
            dt.Columns.Add("Created", System.Type.GetType("System.DateTime"))
            dt.Columns.Add("Accessed", System.Type.GetType("System.DateTime"))
            dt.Columns.Add("IsFolder", System.Type.GetType("System.Boolean"))

            Dim exc As Exception = Nothing
            Dim dv As DataView = Nothing
            Try
                Dim objFolderContents As DirectoryInfo = New DirectoryInfo(_owner.GetSelectedDirectory())
                Dim objEntries() As FileSystemInfo = objFolderContents.GetFileSystemInfos()
                Dim objEntry As FileSystemInfo
                For Each objEntry In objEntries
                    Dim dr As DataRow = dt.NewRow()
                    dr("Name") = objEntry.Name
                    If (objEntry.Attributes And FileAttributes.Directory) <> 0 Then
                        dr("Size") = 0
                        dr("IsFolder") = True
                    Else
                        dr("Size") = CType(objEntry, FileInfo).Length
                        dr("IsFolder") = False
                    End If
                    dr("Modified") = objEntry.LastWriteTime
                    dr("Created") = objEntry.CreationTime
                    dr("Accessed") = objEntry.LastAccessTime
                    dt.Rows.Add(dr)
                Next
                dv = New DataView(dt)
                dv.Sort = arguments.SortExpression
            Catch ex As Exception
                exc = ex
            End Try
            Dim statusEventArgs As New FolderContentsDataSourceStatusEventArgs(exc)
            OnSelected(statusEventArgs)
            If (exc IsNot Nothing And Not statusEventArgs.ExceptionHandled) Then
                Throw exc
            End If
            Return dv
        End Function

        Public Sub OnSelected(ByVal e As FolderContentsDataSourceStatusEventArgs)
            _owner.OnSelected(e)
        End Sub

        Protected Overrides Function ExecuteUpdate(ByVal keys As IDictionary, _
            ByVal values As IDictionary, ByVal oldValues As IDictionary) As Integer

            If (_owner.GetSelectedDirectory() Is Nothing) Then
                Throw New InvalidOperationException("Select parameter missing")
            End If

            If (oldValues("Name") Is Nothing) Then
                Throw New InvalidOperationException("Update parameter missing")
            End If

            Dim exc As Exception = Nothing
            If (values("Name") Is Nothing OrElse values("Name") = "") Then
                exc = New InvalidOperationException("New name is invalid")
            Else
                Dim FileOrFolderToUpdate As String = Path.Combine(_owner.GetSelectedDirectory(), _
                    oldValues("Name"))
                Dim NewName As String = Path.Combine(_owner.GetSelectedDirectory(), _
                    values("Name"))
                Try
                    If (Directory.Exists(FileOrFolderToUpdate)) Then
                        Directory.Move(FileOrFolderToUpdate, NewName)
                    Else
                        File.Move(FileOrFolderToUpdate, NewName)
                    End If
                Catch ex As Exception
                    exc = ex
                End Try
            End If

            Dim statusEventArgs As FolderContentsDataSourceStatusEventArgs = New FolderContentsDataSourceStatusEventArgs(exc)
            OnDeleted(statusEventArgs)
            If (exc IsNot Nothing) Then
                Throw exc
            End If
            Return 1
        End Function

        Public Sub OnUpdated(ByVal e As FolderContentsDataSourceStatusEventArgs)
            _owner.OnUpdated(e)
        End Sub

        Protected Overrides Function ExecuteDelete(ByVal keys As IDictionary, ByVal oldValues As IDictionary) As Integer
            If (_owner.GetSelectedDirectory() Is Nothing) Then
                Throw New InvalidOperationException("Select parameter missing")
            End If

            If (oldValues("Name") Is Nothing) Then
                Throw New InvalidOperationException("Delete parameter missing")
            End If

            Dim FileOrFolderToDelete As String = oldValues("Name")
            Dim FullFileOrFolderToDelete As String = Path.Combine(_owner.GetSelectedDirectory(), _
                FileOrFolderToDelete)
            Dim exc As Exception = Nothing
            Try
                If (Directory.Exists(FullFileOrFolderToDelete)) Then
                    Directory.Delete(FullFileOrFolderToDelete)
                Else
                    File.Delete(FullFileOrFolderToDelete)
                End If
            Catch ex As Exception
                exc = ex
            End Try
            Dim statusEventArgs As FolderContentsDataSourceStatusEventArgs = New FolderContentsDataSourceStatusEventArgs(exc)
            OnDeleted(statusEventArgs)
            If (exc IsNot Nothing) Then
                Throw exc
            End If
            Return 1
        End Function

        Public Sub OnDeleted(ByVal e As FolderContentsDataSourceStatusEventArgs)
            _owner.OnDeleted(e)
        End Sub

        Private Function GetSortPropertyDescriptor(ByVal descriptors As PropertyDescriptorCollection, _
        ByVal sortExpression As String) As PropertyDescriptor
            Dim descriptor As PropertyDescriptor
            For Each descriptor In descriptors
                If (descriptor.Name.Equals(sortExpression, _
                        StringComparison.InvariantCultureIgnoreCase)) Then
                    Return descriptor
                End If
            Next
            Return Nothing
        End Function

        Public Sub RaiseChangedEvent()
            OnDataSourceViewChanged(EventArgs.Empty)
        End Sub

    End Class
End Namespace