Imports Microsoft.VisualBasic
Imports System.Web.UI.Design
Imports System.IO
Imports System.ComponentModel.Design
Imports System.Web.UI.WebControls

Namespace rw
    Public Class FolderContentsDataSourceDesigner
        Inherits DataSourceDesigner

        'Private _dataActionList As DesignerActionList

        'Public Overrides ReadOnly Property ActionLists() As DesignerActionListCollection
        '    Get
        '        If (_dataActionList Is Nothing) Then
        '            _dataActionList = New DataActionList(Me)
        '        End If
        '        Dim _actionLists As DesignerActionListCollection = MyBase.ActionLists
        '        _actionLists.Add(_dataActionList)
        '        Return _actionLists
        '    End Get
        'End Property

        Private _parameters As Parameter
        Public Property Parameters() As Parameter
            Get
                Return _parameters
            End Get
            Set(ByVal value As Parameter)
                _parameters = value
            End Set
        End Property

        Public Overrides Function GetView(ByVal viewName As String) As DesignerDataSourceView
            If (String.IsNullOrEmpty(viewName) Or String.Compare(viewName, "") = 0) Then
                Return New FolderContentsDesignerDataSourceView(Me, "")
            End If
            Throw New ArgumentOutOfRangeException("viewName")
        End Function

        Public Overrides Function GetViewNames() As String()
            Return New String() {""}
        End Function

        Private NotInheritable Class FolderContentsDesignerDataSourceView
            Inherits DesignerDataSourceView

            Private _owner As FolderContentsDataSourceDesigner

            Public Sub New(ByVal owner As FolderContentsDataSourceDesigner, ByVal viewName As String)
                MyBase.New(owner, viewName)
                _owner = owner
            End Sub

            Public Overrides ReadOnly Property Schema() As System.Web.UI.Design.IDataSourceViewSchema
                Get
                    Dim ts As New TypeSchema(GetType(FileSystemInfo))
                    Return ts.GetViews()(0)
                End Get
            End Property

            Public Overrides Function GetDesignTimeData(ByVal minimumRows As Integer, ByRef isSampleData As Boolean) As System.Collections.IEnumerable
                Dim list(minimumRows) As FileSystemInfo

                Try
                    Dim objFolderContents As DirectoryInfo = New DirectoryInfo("c:\")
                    Dim objEntries() As DirectoryInfo = objFolderContents.GetDirectories()
                    Dim objEntry As DirectoryInfo
                    Dim i As Integer = 0
                    For Each objEntry In objEntries
                        list(i) = objEntry
                        i += 1
                        If (i >= minimumRows) Then Exit For
                    Next
                    isSampleData = False
                    Return list
                Catch ex As Exception
                End Try
                isSampleData = True
                Return Nothing
            End Function
        End Class

        Private NotInheritable Class DataActionList
            Inherits DesignerActionList

            Private _owner As FolderContentsDataSourceDesigner

            Public Property Parameters() As Parameter
                Get
                    Return _owner.Parameters
                End Get
                Set(ByVal value As Parameter)
                    _owner.Parameters = value
                End Set
            End Property

            Public Sub New(ByVal owner As FolderContentsDataSourceDesigner)
                MyBase.New(owner.Component)
                _owner = owner
            End Sub

            'Public Overrides Function GetSortedActionItems() As System.ComponentModel.Design.DesignerActionItemCollection
            '    Dim Items As New DesignerActionItemCollection()
            '    Items.Add(New DesignerActionTextItem("Sample Data", "Data"))
            '    Items.Add(New DesignerActionPropertyItem("Parameters", "Parameters", "Data"))
            '    Return Items
            'End Function
        End Class
    End Class

End Namespace

