<%@ Page Language="VB" Debug="True" %>

<%@ Register Assembly="FolderContentsDataSource" Namespace="rw" TagPrefix="cc1" %>

<script runat="server">

    ' selection, deletion and renaming are handled automatically by the FolderContentsDataSource control
    ' the only thing that remains is to catch all errors and display them
    Protected Sub FolderContentsDataSource1_Selected(ByVal sender As Object, ByVal e As rw.FolderContentsDataSourceStatusEventArgs)
        If (e.Exception IsNot Nothing) Then
            lblError.Text = e.Exception.Message
            e.ExceptionHandled = True
        End If
    End Sub
    
    Protected Sub gvFile_RowDeleted(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewDeletedEventArgs)
        If (e.Exception IsNot Nothing) Then
            lblError.Text = e.Exception.Message
            e.ExceptionHandled = True
        End If
    End Sub
    
    Protected Sub gvFile_RowUpdated(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewUpdatedEventArgs)
        If (e.Exception IsNot Nothing) Then
            lblError.Text = e.Exception.Message
            e.ExceptionHandled = True
        End If
    End Sub
    
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Folder contents viewer</title>
    <link href="demo.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <form runat="server" action="demo.aspx">
        <h1>
            Folder Contents Viewer
        </h1>
        <hr />
        Folder name:
        <asp:TextBox ID="tbFolder" runat="server" Width="300px">c:\inetpub\wwwroot</asp:TextBox>
        <asp:Button ID="btnShow" runat="server" Text="Show contents" /><br />
        <asp:Label ID="lblError" runat="server" EnableViewState="False" ForeColor="Red"></asp:Label>
        <br />
        <asp:GridView ID="GridView1" runat="server" Font-Size="X-Small" DataSourceID="FolderContentsDataSource1"
            CellSpacing="2" BorderWidth="0px" AutoGenerateColumns="False" AllowPaging="True"
            PageSize="15" AllowSorting="True" OnRowDeleted="gvFile_RowDeleted" OnRowUpdated="gvFile_RowUpdated">
            <HeaderStyle CssClass="headerstyle" />
            <AlternatingRowStyle CssClass="altstyle" />
            <RowStyle CssClass="itemstyle" />
            <Columns>
                <asp:BoundField DataField="Name" HeaderText="Name" SortExpression="Name" />
                <asp:BoundField DataField="Size" HeaderText="Size" SortExpression="Size" ReadOnly="True" >
                    <ItemStyle HorizontalAlign="Right" />
                </asp:BoundField>
                <asp:BoundField DataField="Modified" HeaderText="Modified" SortExpression="Modified"
                    ReadOnly="True"  />
                <asp:BoundField DataField="Created" HeaderText="Created" SortExpression="Created"
                    ReadOnly="True"  />
                <asp:BoundField DataField="Accessed" HeaderText="Accessed" SortExpression="Accessed" 
                    ReadOnly="True" />
                <asp:CheckBoxField DataField="IsFolder" HeaderText="Is folder" SortExpression="IsFolder" ReadOnly="True" >
                    <ItemStyle HorizontalAlign="Center" />
                </asp:CheckBoxField>
                <asp:TemplateField>
                    <ItemTemplate>
                        &nbsp;&nbsp;
                        <asp:LinkButton ID="btnRename" runat="server" CommandName="Edit" CausesValidation="false"
                            CommandArgument='<%# Container.DataItemIndex %>' Text="rename" ToolTip="Rename file or folder"></asp:LinkButton>
                        <asp:LinkButton ID="btnDelete" runat="server" CommandName="Delete" CausesValidation="false"
                            CommandArgument='<%# Container.DataItemIndex %>' Text="delete" OnClientClick="return confirm('Are you sure?');"></asp:LinkButton>
                    </ItemTemplate>
                    <EditItemTemplate>
                        &nbsp;&nbsp;
                        <asp:LinkButton ID="btnUpdate" runat="server" CommandName="Update" Text="update"
                            CommandArgument='<%# Container.DataItemIndex %>'></asp:LinkButton>&nbsp;
                        <asp:LinkButton ID="btnCancel" runat="server" CommandName="Cancel" CausesValidation="false"
                            Text="cancel"></asp:LinkButton>
                    </EditItemTemplate>
                    <ItemStyle HorizontalAlign="Center" />
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <cc1:FolderContentsDataSource ID="FolderContentsDataSource1" runat="server" OnSelected="FolderContentsDataSource1_Selected">
            <SelectParameters>
                <asp:ControlParameter Name="Directory" Type="String" ControlID="tbFolder" PropertyName="Text" />
            </SelectParameters>
        </cc1:FolderContentsDataSource>
    </form>
</body>
</html>
