Imports Microsoft.VisualBasic
Imports System
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls

Namespace rw
    Public Class ThemeSwitcherModule
        Implements IHttpModule

        Public Sub Dispose() Implements System.Web.IHttpModule.Dispose

        End Sub

        Public Sub Init(ByVal context As System.Web.HttpApplication) Implements System.Web.IHttpModule.Init
            AddHandler context.PreRequestHandlerExecute, AddressOf PreRequestHandlerExecute
        End Sub

        Protected Sub PreRequestHandlerExecute(ByVal sender As Object, ByVal e As EventArgs)
            Dim CurrentContext As HttpContext = HttpContext.Current
            If (Not TypeOf CurrentContext.Handler Is Page) Then Return
            Dim myPage As Page = CurrentContext.Handler
            If Not myPage Is Nothing Then

                ' These 8 lines below handle master pages. Courtesy of Craig G Fraser
                Dim sUniqueID As String = "lbThemeSwitcher"
                Dim sCtrlID As String
                For Each sCtrlID In CurrentContext.Request.Form.AllKeys
                    If sCtrlID.Contains("lbThemeSwitcher") Then
                        sUniqueID = sCtrlID
                        Exit For
                    End If
                Next

                Dim theme As Object = CurrentContext.Request.Form(sUniqueID)
                If (Not theme Is Nothing) Then
                    ' this is postback from the page with the theme switcher list
                    ' handle the user selection in the theme list
                    If (theme.ToString() = "0") Then
                        ' user chose "none"
                        myPage.Theme = ""
                        ' delete the cookie
                        CurrentContext.Response.Cookies(CookieName()).Expires = DateTime.Today.AddDays(-1)
                        Return
                    End If
                    If (ThemeExists(theme)) Then myPage.Theme = theme
                    ' set a cookie for persistence
                    CurrentContext.Response.Cookies(CookieName()).Value = theme
                    CurrentContext.Response.Cookies(CookieName()).Expires = DateTime.Today.AddDays(90) ' 90 days
                Else
                    ' for other pages with no theme switcher on them
                    Dim cookie As Object = CurrentContext.Request.Cookies(CookieName())
                    If (Not cookie Is Nothing AndAlso cookie.Value <> "") Then
                        ' if there's a cookie, get the theme from the cookie
                        If (ThemeExists(cookie.Value)) Then myPage.Theme = cookie.Value
                        cookie.Expires = DateTime.Today.AddDays(90) ' reset expiration date 
                    Else
                        ' if there's no cookie, select the default theme (if it exists)
                        ' the developer should provide a theme with the name "Default"
                        ' if this behavior is wanted
                        If (ThemeExists("Default")) Then myPage.Theme = "Default"
                        Dim DefaultThemeName As String = System.Configuration.ConfigurationManager.AppSettings("DefaultThemeName")
                        If (DefaultThemeName <> "" And ThemeExists(DefaultThemeName)) Then myPage.Theme = DefaultThemeName
                    End If
                End If
            End If
        End Sub

        Private Function ThemeExists(ByVal theme As String) As Boolean
            Return System.IO.Directory.Exists(HttpContext.Current.Server.MapPath("~/App_Themes/" & theme))
        End Function

        Private Function CookieName() As String
            ' name for the cookie that is different for each application
            Dim Path As String = HttpContext.Current.Request.ApplicationPath
            Return Path.Substring(1, Path.Length - 1) & "_tsTheme"
        End Function

    End Class
End Namespace