Imports Microsoft.VisualBasic
Imports System
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.IO
Imports System.ComponentModel

Namespace rw

    ''' <summary>
    ''' This control automatically shows a list with all the available themes.
    ''' </summary>
    ''' <remarks></remarks>
    Public Class ThemeSwitcher
        Inherits ListBox

        ''' <summary>
        ''' Allow the user to choose no theme at all.
        ''' </summary>
        <DefaultValue("False"), Description("Allow the user to choose no theme at all.")> _
        Public Property AllowNoTheme() As Boolean
            Get
                Dim obj As Object = ViewState("AllowNoTheme")
                If obj IsNot Nothing Then
                    Return CBool(obj)
                End If
                Return False
            End Get
            Set(ByVal value As Boolean)
                ViewState("AllowNoTheme") = value
            End Set
        End Property

        ''' <summary>
        ''' Text shown as first item in the list when AllowNoTheme is true. Enables the user to select no theme.
        ''' </summary>
        <DefaultValue("none"), Description("Show this text as the first option when AllowNoTheme is true")> _
        Public Property NoThemeText() As String
            Get
                Dim obj As Object = ViewState("NoThemeText")
                If obj IsNot Nothing Then
                    Return obj.ToString()
                End If
                Return "none"
            End Get
            Set(ByVal value As String)
                ViewState("NoThemeText") = value
            End Set
        End Property

        ''' <summary>
        ''' Perform initialization of the control
        ''' </summary>
        ''' <param name="e">Not used</param>
        ''' <remarks></remarks>
        Protected Overrides Sub OnLoad(ByVal e As System.EventArgs)
            MyBase.OnLoad(e)
            ' force an ID, so we can use it in HttpModule
            ' this implies that there can never be 2 theme switchers on the same page
            Me.ID = "lbThemeSwitcher"
            If (Not Page.IsPostBack) Then
                ' AutoPostBack will be handled in HttpModule
                Me.AutoPostBack = True
                If (Me.AllowNoTheme) Then
                    ' First item is "none"
                    Items.Add(New ListItem(NoThemeText, "0"))
                End If
                If (Directory.Exists(Page.MapPath("~/App_Themes"))) Then
                    ' Enumerate the subfolders of the themes folder and add them to the list
                    Dim subdirs() As String = Directory.GetDirectories(Page.MapPath("~/App_Themes"))
                    For Each dir As String In subdirs
                        Dim dirInfo As New DirectoryInfo(dir)
                        Items.Add(dirInfo.Name)
                    Next
                End If
            End If
            ' set selection to current value of the theme
            SelectedIndex = -1
            If (Page.Theme Is Nothing OrElse Page.Theme = "") Then
                SelectedIndex = 0
            Else
                Dim li As ListItem = Items.FindByValue(Page.Theme)
                If (li IsNot Nothing) Then li.Selected = True
            End If
        End Sub

#Region "HideUselessProperties"
        ' Hide useless properties
        <Browsable(False), _
        DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Shadows Property DataSourceID() As String
            Get
                Return MyBase.DataSourceID
            End Get
            Set(ByVal Value As String)
                MyBase.DataSourceID = Value
            End Set
        End Property

        <Browsable(False), _
        DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Shadows Property DataMember() As String
            Get
                Return MyBase.DataMember
            End Get
            Set(ByVal Value As String)
                MyBase.DataMember = Value
            End Set
        End Property

        <Browsable(False), _
        DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Shadows Property DataTextField() As String
            Get
                Return MyBase.DataTextField
            End Get
            Set(ByVal Value As String)
                MyBase.DataTextField = Value
            End Set
        End Property

        <Browsable(False), _
        DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Shadows Property DataValueField() As String
            Get
                Return MyBase.DataValueField
            End Get
            Set(ByVal Value As String)
                MyBase.DataValueField = Value
            End Set
        End Property

        <Browsable(False), _
        DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Shadows Property DataTextFormatString() As String
            Get
                Return MyBase.DataTextFormatString
            End Get
            Set(ByVal Value As String)
                MyBase.DataTextFormatString = Value
            End Set
        End Property

        <Browsable(False), _
        DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Shadows ReadOnly Property Items() As ListItemCollection
            Get
                Return MyBase.Items
            End Get
        End Property

        <Browsable(False), _
        DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
        Public Shadows ReadOnly Property SelectionMode() As ListSelectionMode
            Get
                Return ListSelectionMode.Single
            End Get
        End Property

#End Region
    End Class

End Namespace
