Public Class DatePickerDynObject

	Private Const m_strMonths As String = "Jan-Feb-March-Apr-Mai-Jun-Jul-Aug-Sep-Oct-Nov-Dec"
	Private Const m_strClose As String = "Close"
	Private Const m_strDays As String = "Su-Mo-Tu-We-Th-Fr-Sa"
	Private Const m_strMonthTitle As String = "Month"
	Private Const m_strPrevMonth As String = "prev. Month"
	Private Const m_strNextMonth As String = "next Month"
	Private Const m_strYearTitle As String = "Year"
	Private Const m_strToday As String = "Today"
	Private Const m_strYesterday As String = "Yesterday"
	Private Const m_strTomorrow As String = "Tomorrow"
	Private Const m_strWeekAgo As String = "prev. Week"
	Private Const m_strWeekAfter As String = "next Week"
	Private Const m_strMonthAgo As String = "prev. Month"
	Private Const m_strMonthAfter As String = "next Month"

	Public Function GenerateDatePicker(ByRef oPage As System.Web.UI.Page, ByRef oSession As System.Web.SessionState.HttpSessionState, ByVal id As String, ByVal value As String, ByVal relpath As String, Optional ByVal tooltip As String = "", Optional ByVal width As String = "64px", Optional ByVal bVisible As Boolean = True, Optional ByVal bDisabled As Boolean = False, Optional ByVal checkfunc As String = "CheckDatePickerDate") As String
		Dim htmlcode As New System.Text.StringBuilder
		Dim sTemp As New System.Text.StringBuilder

		If bVisible Then
			If bDisabled Then

				htmlcode.Append("<!-- {" & id & "}:DatePicker -->" & vbCrLf)
				htmlcode.Append("<input type=" & Chr(34) & "text" & Chr(34) & " class=" & Chr(34) & "DatePickerValue" & Chr(34) & " name=" & Chr(34) & id & Chr(34) & " id=" & Chr(34) & id & Chr(34) & " style=" & Chr(34) & "width: " & width & ";" & Chr(34) & " value=" & Chr(34) & value & Chr(34) & " title=" & Chr(34) & tooltip & Chr(34) & " disabled>")
				htmlcode.Append("<!-- /{" & id & "}:DatePicker -->" & vbCrLf)

			Else
				If Not oPage.IsStartupScriptRegistered("DatePicker") Then
					sTemp.Append(vbCrLf & "<!-- this fragment is needed for DatePicker usage -->" & vbCrLf)
					sTemp.Append("<script language=" & Chr(34) & "javascript" & Chr(34) & " src=" & Chr(34) & relpath & "Js/DatePicker.js" & Chr(34) & "></script>" & vbCrLf)
					sTemp.Append("<span id=" & Chr(34) & "theDatePicker" & Chr(34) & " name=" & Chr(34) & "theDatePicker" & Chr(34) & " class=" & Chr(34) & "DatePicker" & Chr(34) & "></span>" & vbCrLf)
					sTemp.Append("<!-- end of DatePicker fragment -->" & vbCrLf)
					oPage.RegisterStartupScript("DatePicker", sTemp.ToString())
				End If

				htmlcode.Append("<!-- {" & id & "}:DatePicker -->" & vbCrLf)
				htmlcode.Append("<input type=" & Chr(34) & "text" & Chr(34) & " class=" & Chr(34) & "DatePickerValue" & Chr(34) & " name=" & Chr(34) & id & Chr(34) & " id=" & Chr(34) & id & Chr(34) & " maxlength=" & Chr(34) & "10" & Chr(34) & " style=" & Chr(34) & "width: " & width & ";" & Chr(34) & " value=" & Chr(34) & value & Chr(34) & " title=" & Chr(34) & tooltip & Chr(34) & " onChange=" & Chr(34) & checkfunc & "('" & id & "')" & Chr(34) & ">")
				htmlcode.Append("&nbsp;")
				htmlcode.Append("<img src=" & Chr(34) & relpath & "Images/DatePicker/dp.gif" & Chr(34) & " class=" & Chr(34) & "LinkedElement" & Chr(34) & " onclick=" & Chr(34) & "DatePickerShow(" & id & ", " & id & "Ch,'" & relpath & "'," & GetLabels(oSession) & ");" & Chr(34) & " title=" & Chr(34) & Chr(34) & " name=" & Chr(34) & id & "Ch" & Chr(34) & " id=" & Chr(34) & id & "Ch" & Chr(34) & " title=" & Chr(34) & Chr(34) & ">" & vbCrLf)
				htmlcode.Append("<!-- /{" & id & "}:DatePicker -->" & vbCrLf)

			End If
		End If

		Return htmlcode.ToString()
	End Function

	Private Function GetLabels(ByRef oSession As System.Web.SessionState.HttpSessionState) As String
		Dim labels As New System.Text.StringBuilder
		Dim transDest As String = ""

		If oSession("LANGUAGE") = 0 Then
			labels.Append("'")
			labels.Append(m_strMonths)
			labels.Append("','")
			labels.Append(m_strClose)
			labels.Append("','")
			labels.Append(m_strDays)
			labels.Append("','")
			labels.Append(m_strMonthTitle)
			labels.Append("','")
			labels.Append(m_strPrevMonth)
			labels.Append("','")
			labels.Append(m_strNextMonth)
			labels.Append("','")
			labels.Append(m_strYearTitle)
			labels.Append("','")
			labels.Append(m_strToday)
			labels.Append("','")
			labels.Append(m_strYesterday)
			labels.Append("','")
			labels.Append(m_strTomorrow)
			labels.Append("','")
			labels.Append(m_strWeekAgo)
			labels.Append("','")
			labels.Append(m_strWeekAfter)
			labels.Append("','")
			labels.Append(m_strMonthAgo)
			labels.Append("','")
			labels.Append(m_strMonthAfter)
			labels.Append("'")
		Else
		    ' Do the translation here
		End If

		Return labels.ToString()
	End Function

End Class
