Imports System.ComponentModel
Imports System.Web.UI

Namespace MyOwnWebControls

	<DefaultProperty("Text"), ToolboxData("<{0}:DatePickerControl runat=server></{0}:DatePickerControl>")> Public Class DatePickerControl
		Inherits System.Web.UI.Control

		Dim m_text As String = ""
		Dim m_relpath As String = "../"
		Dim m_bDisabled As Boolean = False
		Dim m_width As String = "64px"
		Dim m_tooltip As String = ""
		Dim m_checkfunc As String = "CheckDatePickerDate"

		<Bindable(True), Category("Appearance"), Description("active content"), DefaultValue("")> Property Text() As String
			Get
				Return m_text
			End Get

			Set(ByVal Value As String)
				m_text = Value
			End Set
		End Property

		<Bindable(True), Category("Appearance"), Description("relative Path to images"), DefaultValue("../")> Property RelPath() As String
			Get
				Return m_relpath
			End Get

			Set(ByVal Value As String)
				m_relpath = Value
			End Set
		End Property

		<Bindable(True), Category("Appearance"), Description("Tooltip"), DefaultValue("")> Property Tooltip() As String
			Get
				Return m_tooltip
			End Get

			Set(ByVal Value As String)
				m_tooltip = Value
			End Set
		End Property

		<Bindable(True), Category("Appearance"), Description("Width in Pixel incl. 'px'"), DefaultValue("64px")> Property Width() As String
			Get
				Return m_width
			End Get

			Set(ByVal Value As String)
				m_width = Value
			End Set
		End Property

		<Bindable(True), Category("Appearance"), Description("JavaScript-Function to validate user input"), DefaultValue("CheckDatePickerDate")> Property CheckFunc() As String
			Get
				Return m_checkfunc
			End Get

			Set(ByVal Value As String)
				m_checkfunc = Value
			End Set
		End Property

		<Bindable(True), Category("Appearance"), DefaultValue(False)> Property Disabled() As Boolean
			Get
				Return m_bDisabled
			End Get

			Set(ByVal Value As Boolean)
				m_bDisabled = Value
			End Set
		End Property

		' Override the OnInit method to write text to the 
		' containing page if the _text property is null.
		<System.Security.Permissions.PermissionSetAttribute(System.Security.Permissions.SecurityAction.Demand, Name:="FullTrust")> _
		Protected Overrides Sub OnInit(ByVal e As EventArgs)
			MyBase.OnInit(e)
			Me.Page = Me.Parent.Page
			Me.m_text = Me.Page.Request.Form(Me.ID)
		End Sub		  'OnInit

		' Rendern des Elementes
		Protected Overrides Sub Render(ByVal output As System.Web.UI.HtmlTextWriter)

			Dim oDP As New DatePickerDynObject

			output.Write(oDP.GenerateDatePicker(Me.Page, Me.Page.Session, Me.ID, m_text, m_relpath, m_tooltip, m_width, Me.Visible, m_bDisabled, m_checkfunc))

			oDP = nothing
		End Sub

	End Class

End Namespace
