using System;
using System.ComponentModel;
using System.Security.Permissions;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;

namespace YControls
{
    public enum CheckBoxState
    {
        Checked = 1,
        UnChecked = 0,
        Undefined = Byte.MaxValue
    }

    /// <summary>
    /// 
    /// </summary>
    [
    DefaultProperty("Value"),
    ToolboxData("<{0}:Register runat=\"server\"> </{0}:Register>"),
    ]
    public class YTripleStateCheckBox : CompositeControl
    {
        private System.Web.UI.WebControls.Image image;
        private System.Web.UI.WebControls.Label label;
        private System.Web.UI.WebControls.HiddenField hiddenField;
        private bool enabled = true;

        private string cssCheckBoxUndefined = "CheckBoxUnDefined";
        private string cssCheckBoxChecked = "CheckBoxChecked";
        private string cssCheckBoxUnChecked = "CheckBoxUnChecked";


        // The following properties are delegated to 
        // child controls.
        [
        Bindable(true),
        Category("Default"),
        DefaultValue(""),
        Description("Value")
        ]
        public byte Value
        {
            get
            {
                EnsureChildControls();
                byte toReturn = 0;
                byte.TryParse(this.hiddenField.Value, out toReturn);
                return toReturn;
            }

            set
            {
                EnsureChildControls();

                this.hiddenField.Value = value.ToString();
            }
        }

        // The following properties are delegated to 
        // child controls.
        [
        Bindable(true),
        Category("Default"),
        DefaultValue("true"),
        Description("Enabled")
        ]
        public bool Enabled
        {
            get
            {
                return enabled;
            }

            set
            {
                enabled = value;
            }
        }

        // The following properties are delegated to 
        // child controls.
        [
        Bindable(true),
        Category("Default"),
        DefaultValue(""),
        Description("Text")
        ]
        public string Text
        {
            get
            {
                EnsureChildControls();
                return label.Text;
            }
            set
            {
                EnsureChildControls();
                label.Text = value;
            }
        }

        protected override void RecreateChildControls()
        {
            EnsureChildControls();
        }


        protected override void CreateChildControls()
        {
            Controls.Clear();

            image = new System.Web.UI.WebControls.Image();
            label = new System.Web.UI.WebControls.Label();
            hiddenField = new System.Web.UI.WebControls.HiddenField();

            this.Controls.Add(image);
            this.Controls.Add(label);
            this.Controls.Add(hiddenField);
        }


        protected override void OnPreRender(EventArgs e)
        {
            if (enabled) //Enabled
            {
                image.Attributes.Add("onclick", "TriplestateCheckBoxHandler(this, '" + this.hiddenField.ClientID + "')");
            }

            if (string.IsNullOrEmpty(hiddenField.Value))
            {
                Value = Convert.ToByte(CheckBoxState.Undefined); //Default if nothing is passed
            }

            string blankImage = ResolveUrl("~/images/blank.gif");
            image.ImageUrl = blankImage;

            CheckBoxState currentState = (CheckBoxState)Value;

            switch (currentState)
            {
                case CheckBoxState.Undefined:
                    image.CssClass = cssCheckBoxUndefined;
                    break;
                case CheckBoxState.Checked:
                    image.CssClass = cssCheckBoxChecked;
                    break;
                case CheckBoxState.UnChecked:
                    image.CssClass = cssCheckBoxUnChecked;
                    break;
            }

            //Registering Javascript handler for the triple state checkbox
            if (!Page.ClientScript.IsStartupScriptRegistered("TripleStateCheckBox"))
            {
                Page.ClientScript.RegisterStartupScript(GetType(), "TripleStateCheckBox", TripleStateCheckBoxJavascript(), true);
            }

            base.OnPreRender(e);
        }

        private string TripleStateCheckBoxJavascript()
        {
            StringBuilder sb = new StringBuilder();

            sb.AppendLine("function TriplestateCheckBoxHandler(chkBox, hiddenFieldId)");
            sb.AppendLine("{");
            sb.AppendLine("   var hiddenField = document.getElementById(hiddenFieldId);");
            sb.AppendLine("   var Checked = '" + ((byte)CheckBoxState.Checked).ToString() + "';");
            sb.AppendLine("   var UnChecked = '" + ((byte)CheckBoxState.UnChecked).ToString() + "';");
            sb.AppendLine("   var Undefined = '" + ((byte)CheckBoxState.Undefined).ToString() + "';");
            sb.AppendLine(""); 
            sb.AppendLine("switch (hiddenField.value)");
            sb.AppendLine("{");
            sb.AppendLine("   case Undefined:");
            sb.AppendLine("      hiddenField.value = Checked;");
            sb.AppendLine("      break;");
            sb.AppendLine("   case Checked:");
            sb.AppendLine("      hiddenField.value = UnChecked;");
            sb.AppendLine("      break;");
            sb.AppendLine("   case UnChecked:");
            sb.AppendLine("      hiddenField.value = Undefined;");
            sb.AppendLine("      break;");
            sb.AppendLine("}");
            
            sb.AppendLine("var className;");
            sb.AppendLine("switch (hiddenField.value)");
            sb.AppendLine("{");
            sb.AppendLine("   case Undefined:");
            sb.AppendLine("      className = '" + cssCheckBoxUndefined + "';");
            sb.AppendLine("      break;");
            sb.AppendLine("   case Checked:");
            sb.AppendLine("      className = '" + cssCheckBoxChecked + "';");
            sb.AppendLine("      break;");
            sb.AppendLine("   case UnChecked:");
            sb.AppendLine("      className = '" + cssCheckBoxUnChecked + "';");
            sb.AppendLine("      break;");
            sb.AppendLine("}");
            sb.AppendLine("chkBox.className = className;");
            sb.AppendLine("}");

            return sb.ToString();
        }

        protected override void Render(HtmlTextWriter writer)
        {
            AddAttributesToRender(writer);

            writer.RenderBeginTag(HtmlTextWriterTag.Div);
            image.RenderControl(writer);
            writer.Write("&nbsp;");
            label.RenderControl(writer);
            hiddenField.RenderControl(writer);
            writer.RenderEndTag();
        }
    }
}
