Imports System.Data.SqlClient
Imports System.Data

Public Class UserPolls

    Private Database As String = "UserPolls"
    Public ErrorMessage As String
    Public Connection As String = ConfigurationManager.ConnectionStrings("UserPolls").ToString


    Public Function CanVote(ByVal PollId As Integer, ByVal MemberId As Integer) As Boolean
        Dim params As SqlParameter() = {New SqlParameter("@PollId", SqlDbType.Int), New SqlParameter("@MemberId", SqlDbType.Int)}
        Dim ds As New DataSet
        Me.Database = "UserPolls"
        params(0).Value = PollId
        params(1).Value = MemberId
        ds = (ExecuteSp("MemberCanVote", params))
        If ds.Tables.Count > 0 Then
            If CInt(ds.Tables(0).Rows(0).Item("voted")) > 0 Then
                Return False
            Else
                Return True
            End If
        Else
            Return True
        End If
    End Function

    Public Function CastVote(ByVal PollId As Integer, ByVal Answer As Integer, ByVal MemberId As Integer) As Boolean
        Dim cmd As New SqlCommand("InsertPollResult", New SqlConnection(Connection))
        With cmd.Parameters
            .AddWithValue("@PollId", PollId)
            .AddWithValue("@PollChoice", Answer)
            .AddWithValue("@MemberId", MemberId)
        End With
        Return (SqlExecuteInsertSp(cmd) > 0)
    End Function

    Public Function GetPolls(ByVal SiteId As Integer) As DataSet
        Dim ds As New DataSet
        Dim params As SqlParameter() = {New SqlParameter("@SiteId", SqlDbType.Int)}
        params(0).Value = SiteId
        ds = ExecuteSp("SelectPolls", params)
        If ds.Tables.Count > 0 Then
            Dim dr As DataRow
            For Each dr In ds.Tables(0).Rows
                dr.Item("CreatedByName") = dr.Item("CreatedBy")
            Next
        End If
        Return ds
    End Function

    Public Function GetPollAnswers(ByVal PollId As Integer) As DataSet
        Me.Database = "UserPolls"
        Dim params As SqlParameter() = {New SqlParameter("@PollId", SqlDbType.Int)}
        params(0).Value = PollId
        Return ExecuteSp("SelectPollAnswers", params)
    End Function

    Public Function InsertPollQuestion(ByVal SiteId As Integer, ByVal PollQuestion As String, ByVal CloseType As Integer, ByVal CloseDate As String, ByVal MemberId As Integer) As Integer
        Dim cmd As New SqlCommand("InsertPollQuestion", New SqlConnection(Connection))
        With cmd.Parameters
            .AddWithValue("@SiteId", SiteId)
            .AddWithValue("@PollQuestion", PollQuestion)
            .AddWithValue("@CloseType", CloseType)
            If CloseDate <> "" Then
                .AddWithValue("@CloseDate", CloseDate)
            Else
                .AddWithValue("@CloseDate", Nothing)
            End If
            .AddWithValue("@CreatedBy", MemberId)
        End With
        Return SqlExecuteInsertSpGetId(cmd)
    End Function

    Public Function InsertPollAnswer(ByVal PollId As Integer, ByVal AnswerText As String, ByVal AnswerColor As String) As Boolean
        Dim cmd As New SqlCommand("InsertPollAnswer", New SqlConnection(Connection))
        With cmd.Parameters
            .AddWithValue("@PollId", PollId)
            .AddWithValue("@AnswerText", AnswerText)
            .AddWithValue("@AnswerColor", AnswerColor)
        End With
        Return (SqlExecuteInsertSp(cmd) > 0)
    End Function

    Public Function DeletePoll(ByVal PollId As Integer) As Boolean
        Return (SqlExecuteDeleteSp("DeletePoll", "PollId", PollId) > 0)
    End Function

    Public Function DeletePoll(ByVal PollId As Integer, ByVal MemberId As Integer) As Boolean
        Dim cmd As New SqlCommand("DeleteVote", New SqlConnection(Connection))
        With cmd.Parameters
            .AddWithValue("@PollId", PollId)
            .AddWithValue("@MemberId", MemberId)
        End With
        Return (SqlExecuteDeleteSp(cmd) > 0)
    End Function

#Region "*** SQL SERVER METHODS ***"
    Public Function SqlExecuteInsertSp(ByVal cmd As SqlCommand) As Integer
        Dim i As Integer
        cmd.CommandType = CommandType.StoredProcedure
        Try
            cmd.Connection.Open()
            i = cmd.ExecuteNonQuery()
        Catch ex As Exception
            ErrorMessage = "ProDBObject.SqlExecuteInsertSp(SqlCommand): " & ex.Message.ToString
        Finally
            cmd.Connection.Close()
        End Try
        Return i
    End Function

    Public Function SqlExecuteInsertSpGetId(ByVal cmd As SqlCommand) As Integer
        '=====================================================================
        'Execute an Insert Stored Procedure and return the Autonumber field
        '=====================================================================
        Dim i As Integer
        Dim par As New SqlParameter("@RETURN_VALUE", SqlDbType.Int)

        cmd.CommandType = CommandType.StoredProcedure
        par.Direction = ParameterDirection.ReturnValue
        cmd.Parameters.Add(par)

        Try
            cmd.Connection.Open()
            i = cmd.ExecuteNonQuery()
        Catch ex As Exception
            ErrorMessage = "ProDBObject.SqlExecuteInsertSpGetId(SqlCommand): " & ex.Message.ToString
        Finally
            cmd.Connection.Close()
        End Try
        Dim parVal As Integer = Convert.ToInt32(par.Value)
        Return parVal

    End Function

    Public Function SqlExecuteDeleteSp(ByVal spName As String, ByVal FieldName As String, ByVal FieldValue As String) As Integer
        Dim dataSource As New SqlDataSource
        Dim i As Integer
        With dataSource
            .ConnectionString = Connection
            .DeleteCommandType = SqlDataSourceCommandType.StoredProcedure
            .DeleteCommand = spName
            .DeleteParameters.Add(FieldName, FieldValue)
            Try
                i = .Delete()
            Catch ex As Exception
                ErrorMessage = "ProDBObject.ExecuteDeleteSp(Proc,Field,Value): " & ex.Message.ToString
            Finally
                dataSource = Nothing
            End Try
        End With
        Return i
    End Function

    Public Function SqlExecuteDeleteSp(ByVal cmd As SqlCommand) As Integer
        Dim i As Integer
        cmd.CommandType = CommandType.StoredProcedure
        Try
            cmd.Connection.Open()
            i = cmd.ExecuteNonQuery()
        Catch ex As Exception
            ErrorMessage = "ProDBObject.SqlExecuteDeleteSp(SqlCommand): " & ex.Message.ToString
        Finally
            cmd.Connection.Close()
        End Try
        Return i
    End Function

    Public Function ExecuteSp(ByVal spName As String, ByVal pars As IDataParameter()) As DataSet
        Dim cn As New SqlConnection(Connection)
        Dim ds As New DataSet
        Dim da As New SqlDataAdapter()
        Try
            cn.Open()
            da.SelectCommand = BuildQueryCommand(cn, spName, pars)
            da.Fill(ds)
        Catch ex As Exception
            ErrorMessage = "ProDBObject.ExecuteSp(Proc, Params) : " & ex.Message.ToString
        Finally
            da = Nothing
            cn.Close()
            cn = Nothing
        End Try

        Return ds
    End Function

    Private Function BuildQueryCommand(ByVal sqlCn As SqlConnection, ByVal storedProcName As String, _
        ByVal parameters As IDataParameter()) As SqlCommand
        Dim command As New SqlCommand(storedProcName, sqlCn)
        command.CommandType = CommandType.StoredProcedure

        Dim parameter As SqlParameter
        For Each parameter In parameters
            command.Parameters.Add(parameter)
        Next
        Return command
    End Function
#End Region

End Class

