Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Text
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Drawing

Namespace EccSoft.Web.UI
    <DefaultProperty("Text"), ToolboxData("<{0}:PollControl runat=server></{0}:PollControl>"), Serializable()> _
Public Class PollControl
        Inherits CompositeControl

        Public Event CastVote(ByVal PollId As Integer, ByVal AnswerId As String, ByVal MemberId As Integer)
        Private WithEvents btn As New ImageButton

        Private _SelectedValue As String
        Private _PollAnswers As New PollAnswers
        Private _MemberId As Integer
        Private _SiteId As Integer
        Private _ImagesFolder As String = "Images/"

        Dim hid As New HtmlControls.HtmlInputHidden
        Dim hidVote As New HtmlControls.HtmlInputHidden

        <Bindable(True), Category("Data"), DefaultValue(False), Localizable(True)> _
        Property ShowPercentage() As Boolean
            Get
                Dim s As String = CStr(ViewState("ShowPercentage"))
                If s Is Nothing Then
                    Return False
                Else
                    Return CBool(s)
                End If
            End Get
            Set(ByVal value As Boolean)
                ViewState("ShowPercentage") = value
            End Set
        End Property

        <Bindable(True), Category("Data"), Localizable(True)> _
        Property ShowMemberCount() As Boolean
            Get
                Dim s As String = CStr(ViewState("ShowMemberCount"))
                If s Is Nothing Then
                    Return False
                Else
                    Return CBool(s)
                End If
            End Get
            Set(ByVal value As Boolean)
                ViewState("ShowMemberCount") = value
            End Set
        End Property

        <Bindable(True), Category("Appearance"), DefaultValue("Poll Question"), Localizable(True)> _
        Public ReadOnly Property PollAnswer() As PollAnswers
            Get
                Dim s As PollAnswers = CType(ViewState("PollAnswers"), PollAnswers)
                If s Is Nothing Then
                    Return Nothing
                Else
                    Return s
                End If
            End Get
        End Property

        Public Property MemberId() As Integer
            Get
                Return _MemberId
            End Get
            Set(ByVal value As Integer)
                _MemberId = value
            End Set
        End Property

        Public Property SiteId() As Integer
            Get
                Return _SiteId
            End Get
            Set(ByVal value As Integer)
                _SiteId = value
            End Set
        End Property

        <Bindable(True), Category("Data"), DefaultValue(0), Localizable(True)> _
        Public Property PollId() As Integer
            Get
                Dim s As Integer = CInt(ViewState("PollId"))
                Return s
            End Get
            Set(ByVal value As Integer)
                ViewState("PollId") = value
            End Set
        End Property

        <Bindable(True), Category("Data"), DefaultValue(""), Localizable(True), NotifyParentProperty(True)> _
        Public Property ImagesFolder() As String
            Get
                If _ImagesFolder.EndsWith("/") Then
                    Return _ImagesFolder
                Else
                    Return _ImagesFolder & "/"
                End If
            End Get

            Set(ByVal Value As String)
                _ImagesFolder = Value
            End Set
        End Property

        <Bindable(True), Category("Appearance"), Localizable(True), NotifyParentProperty(True)> _
        Public Property CSSPollClass() As String
            Get
                Dim s As String = CStr(ViewState("CSSPollClass"))
                If s Is Nothing Then
                    Return String.Empty
                Else
                    Return s
                End If
            End Get

            Set(ByVal Value As String)
                ViewState("CSSPollClass") = Value
            End Set
        End Property

        <Bindable(True), Category("Appearance"), Localizable(True), NotifyParentProperty(True)> _
        Public Property CSSCaption() As String
            Get
                Dim s As String = CStr(ViewState("CSSCaption"))
                If s Is Nothing Then
                    Return String.Empty
                Else
                    Return s
                End If
            End Get

            Set(ByVal Value As String)
                ViewState("CSSCaption") = Value
            End Set
        End Property

        <Bindable(True), Category("Appearance"), DefaultValue("Votes Cast"), Localizable(True)> _
        Public Property VotesCaption() As String
            Get
                Dim s As String = CStr(ViewState("VotesCaption"))
                If s Is Nothing Then
                    Return String.Empty
                Else
                    Return s
                End If
            End Get

            Set(ByVal Value As String)
                ViewState("VotesCaption") = Value
            End Set
        End Property

        <Bindable(True), Category("Appearance"), DefaultValue("Poll Question"), Localizable(True)> _
        Public Property PollQuestion() As String
            Get
                Dim s As String = CStr(ViewState("PollQuestion"))
                If s Is Nothing Then
                    Return String.Empty
                Else
                    Return s
                End If
            End Get

            Set(ByVal Value As String)
                ViewState("PollQuestion") = Value
            End Set
        End Property

        <Bindable(True), Category("Data"), DefaultValue(0), Localizable(True)> _
        Public Property MemberCount() As Integer
            Get
                Dim s As Integer = CInt(ViewState("MemberCount"))
                Return s
            End Get

            Set(ByVal Value As Integer)
                ViewState("MemberCount") = Value
            End Set
        End Property

        <Bindable(True), Category("Data"), DefaultValue(1), Localizable(True)> _
        Public Property AnswerCount() As Integer
            Get
                Dim s As Integer = CInt(ViewState("AnswerCount"))
                Return s
            End Get

            Set(ByVal Value As Integer)
                ViewState("AnswerCount") = Value
            End Set
        End Property

        <Bindable(True), Category("Data"), DefaultValue(0), Localizable(True)> _
        Public Property VoteCount() As Integer
            Get
                Dim s As Integer = CInt(ViewState("VoteCount"))
                Return s
            End Get
            Set(ByVal Value As Integer)
                ViewState("VoteCount") = Value
            End Set
        End Property

        <Bindable(True), Category("Data"), DefaultValue(True), Localizable(True)> _
        Public Property CanVote() As Boolean
            Get
                Dim s As String = CStr(ViewState("CanVote"))
                If s Is Nothing Then
                    Return False
                Else
                    Return CBool(s)
                End If
            End Get
            Set(ByVal value As Boolean)
                ViewState("CanVote") = value
                hidVote.Value = value.ToString
            End Set
        End Property

        <Bindable(True), Category("Appearance"), DefaultValue(""), Localizable(True)> _
        Property Text() As String
            Get
                Dim s As String = CStr(ViewState("Text"))
                If s Is Nothing Then
                    Return String.Empty
                Else
                    Return s
                End If
            End Get

            Set(ByVal Value As String)
                ViewState("Text") = Value
            End Set
        End Property

        Public Sub AddPollAnswer(ByVal PollId As Integer, ByVal AnswerId As Integer, ByVal AnswerText As String, ByVal Answers As Integer)
            If _PollAnswers.Count = 0 Then
                VoteCount = 0
            End If
            _PollAnswers.AddAnswer(PollId, AnswerId, AnswerText, Answers)
            VoteCount += Answers
            ViewState.Add("PollAnswers", _PollAnswers)
        End Sub

        Protected Overrides Sub CreateChildControls()
            If Not Page.IsCallback Then
                Me.Controls.Clear()
                If CanVote Then
                    Me.Controls.Add(PollTable())
                Else
                    Me.Controls.Add(ShowResults())
                End If
            End If
        End Sub

        Private Function ShowResults() As Table
            Dim tbl As New Table
            If Me.Width.IsEmpty Then
                tbl.Width = Unit.Percentage(100)
            Else
                tbl.Width = Me.Width
            End If
            tbl.CellPadding = 4
            tbl.CellSpacing = 2
            tbl.CssClass = Me.CSSPollClass

            Dim tr As New TableRow
            Dim tc As New TableCell

            Dim tbl1 As New Table
            tbl1.CssClass = Me.CSSCaption
            tbl1.Width = Unit.Percentage(100)
            tbl1.CellPadding = 4
            tbl1.CellSpacing = 2

            Dim tr1 As New TableRow
            Dim tc1 As New TableCell
            tc.CssClass = Me.CSSCaption

            Try
                tc.Controls.Add(MakeQuestionTable())
            Catch ex As Exception
                tc.Controls.Add(New LiteralControl(ex.Message.ToString))
            End Try

            tr.Cells.Add(tc)
            tbl.Rows.Add(tr)

            hidVote.ID = "hidVote"
            tc.Controls.Add(hidVote)
            tr.Cells.Add(tc)
            tbl.Rows.Add(tr)
            tr = New TableRow
            tc = New TableCell

            tbl1 = New Table
            tbl1.Width = Unit.Percentage(100)
            tbl1.CellPadding = 2
            tbl1.CellSpacing = 2

            If Not Me.DesignMode Then

                If Not PollAnswer Is Nothing Then
                    Dim i As Integer = 1
                    Dim pa As PollAnswer
                    For Each pa In PollAnswer.GetAnswers()
                        tr1 = New TableRow
                        tc1 = New TableCell
                        tc1.Wrap = False
                        tc1.HorizontalAlign = HorizontalAlign.Left
                        tc1.Controls.Add(New LiteralControl(pa.AnswerText))
                        tr1.Cells.Add(tc1)

                        tc1 = New TableCell
                        tc1.BorderStyle = WebControls.BorderStyle.Inset
                        tc1.BorderWidth = Unit.Pixel(2)
                        tc1.Width = Unit.Percentage(100)
                        Dim tbl2 As New Table
                        tbl2.CellPadding = 0
                        tbl2.CellSpacing = 0
                        tbl2.Height = Unit.Pixel(20)
                        If VoteCount <> 0 Then
                            If i > 10 Then i = 1
                            tbl2.Width = Unit.Percentage(CInt((pa.AnswerCount / VoteCount) * 100))
                            tbl2.BackImageUrl = ImagesFolder & "Bar" & i.ToString & ".jpg"
                        Else
                            tbl2.Width = 0
                        End If

                        'tbl2.BackColor = pa.AnswerColor
                        Dim tr2 As New TableRow
                        Dim tc2 As New TableCell
                        tr2.Height = Unit.Pixel(20)
                        tc2.Controls.Add(New LiteralControl("&nbsp"))
                        tr2.Cells.Add(tc2)
                        tbl2.Rows.Add(tr2)
                        tc1.Controls.Add(tbl2)
                        tr1.Cells.Add(tc1)

                        tc1 = New TableCell
                        tc1.Wrap = False
                        If Me.ShowPercentage Then
                            tc1.Controls.Add(New LiteralControl(String.Format("{0:#0.0 %}", (pa.AnswerCount / VoteCount))))
                        Else
                            tc1.Controls.Add(New LiteralControl(pa.AnswerCount.ToString))
                        End If
                        tc1.HorizontalAlign = HorizontalAlign.Right
                        tr1.Cells.Add(tc1)
                        tbl1.Rows.Add(tr1)
                        i += 1
                    Next

                    tc.Controls.Add(tbl1)
                End If
            End If

            tr.Cells.Add(tc)
            tbl.Rows.Add(tr)

            Return tbl
        End Function

        Private Function MakeQuestionTable() As Table
            Dim tbl As New Table
            Dim showmem As Boolean

            Try
                showmem = Me.ShowMemberCount
            Catch ex As Exception
                showmem = False
            End Try

            tbl.Width = Unit.Percentage(100)
            tbl.CellPadding = 4
            tbl.CellSpacing = 2

            ' add a row for the vote count and caption
            Dim tr As New TableRow
            Dim tc As New TableCell
            If showmem Then
                tc.HorizontalAlign = HorizontalAlign.Left
            Else
                tc.HorizontalAlign = HorizontalAlign.Right
            End If

            tc.VerticalAlign = VerticalAlign.Middle
            tr.CssClass = Me.CSSCaption
            Dim lbl As New Label
            lbl.Text = Me.VotesCaption & " " & Me.VoteCount.ToString
            tc.Controls.Add(lbl)
            tr.Cells.Add(tc)

            ' if we are displaying the member count add a column for member count
            If showmem Then
                tc = New TableCell
                tc.HorizontalAlign = HorizontalAlign.Right
                tc.VerticalAlign = VerticalAlign.Middle
                lbl = New Label
                lbl.Text = "Members : " & Me.MemberCount.ToString
                tc.Controls.Add(lbl)
                tr.Cells.Add(tc)
            End If
            tbl.Rows.Add(tr)

            ' Add a row for the Question
            tr = New TableRow
            tr.CssClass = Me.CSSCaption
            tc = New TableCell
            If showmem Then
                tc.ColumnSpan = 2
            End If

            lbl = New Label
            lbl.Text = Me.PollQuestion
            tc.Controls.Add(lbl)
            tr.Cells.Add(tc)
            tbl.Rows.Add(tr)
            Return tbl
        End Function

        Private Function PollTable() As Table
            Dim tbl As New Table
            If Me.Width.IsEmpty Then
                tbl.Width = Unit.Percentage(100)
            Else
                tbl.Width = Me.Width
            End If
            tbl.CellPadding = 4
            tbl.CellSpacing = 2
            tbl.CssClass = Me.CSSPollClass

            Dim tr As New TableRow
            Dim tc As New TableCell

            Dim tbl1 As New Table
            tbl1.CssClass = Me.CSSCaption
            tbl1.Width = Unit.Percentage(100)
            tbl1.CellPadding = 4
            tbl1.CellSpacing = 2

            Dim tr1 As New TableRow
            Dim tc1 As New TableCell
            tc.CssClass = Me.CSSCaption

            Try
                tc.Controls.Add(MakeQuestionTable())
            Catch ex As Exception
                tc.Controls.Add(New LiteralControl(ex.Message.ToString))
            End Try

            tr.Cells.Add(tc)
            tbl.Rows.Add(tr)

            hidVote.ID = "hidVote"
            tc.Controls.Add(hidVote)
            tr.Cells.Add(tc)
            tbl.Rows.Add(tr)

            tr = New TableRow
            tc = New TableCell
            tc.HorizontalAlign = HorizontalAlign.Left

            hid.ID = "hid"
            Dim ctl As RadioButton
            ctl = New RadioButton

            ctl.ID = "PollAnswers"
            ctl.Attributes.Add("onclick", Me.ClientID & "_hid.value=this.value")

            ctl.CssClass = Me.CssClass

            If CanVote Then
                If (Not Me.DesignMode) And (Not PollAnswer Is Nothing) Then
                    Dim pa As PollAnswer
                    Dim i As Integer = 1
                    For Each pa In PollAnswer.GetAnswers()
                        tr = New TableRow
                        tc = New TableCell
                        ctl = New RadioButton
                        If i = 1 Then
                            ctl.Checked = True
                            hid.Value = 1
                        End If
                        ctl.ID = pa.AnswerId
                        ctl.Attributes.Add("onclick", Me.ClientID & "_hid.value=this.value")
                        ctl.Text = pa.AnswerText
                        ctl.ValidationGroup = "ANSWER"
                        ctl.GroupName = "ANSWER"
                        tc.Controls.Add(ctl)
                        tr.Cells.Add(tc)
                        tbl.Rows.Add(tr)
                        i += 1
                    Next

                    tc.Controls.Add(hid)
                    tr.Cells.Add(tc)
                    tbl.Rows.Add(tr)
                End If
                tr = New TableRow
                tc = New TableCell
                tc.BorderStyle = WebControls.BorderStyle.Solid
                tc.BorderWidth = Unit.Pixel(1)
                tc.BorderColor = Color.DarkGray

                btn.ID = "cmdVote"
                btn.ImageUrl = "~/Images/CastVote.jpg"
                btn.ToolTip = "Cast your vote!"
                btn.Attributes.Add("onclick", Me.ClientID & "_hidVote.value='False';")

                btn.CssClass = Me.CssClass
                btn.BorderColor = Color.Black
                btn.BorderStyle = WebControls.BorderStyle.Solid
                btn.BorderWidth = Unit.Pixel(1)

                tc.HorizontalAlign = HorizontalAlign.Right
                tc.Controls.Add(btn)
                tr.Cells.Add(tc)
                tbl.Rows.Add(tr)
            End If

            Return tbl
        End Function

        Private Sub btn_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btn.Click
            RaiseEvent CastVote(Me.PollId, hid.Value, Me.MemberId)
        End Sub

    End Class

    <Serializable()> _
    Public Class PollAnswer
        Public PollId As Integer
        Public AnswerId As Integer
        Public AnswerText As String
        Public AnswerCount As Integer
    End Class

    <Serializable()> _
    Public Class PollAnswers
        Inherits CollectionBase

        Public Sub AddAnswer(ByVal pId As Integer, ByVal aId As Integer, ByVal aText As String, ByVal aCount As Integer)
            Dim pa As New PollAnswer
            pa.AnswerId = aId
            pa.AnswerText = aText
            pa.PollId = pId
            pa.AnswerCount = aCount
            Me.List.Add(pa)
        End Sub

        Public Function GetAnswers() As PollAnswers
            Return Me.List
        End Function

    End Class

End Namespace
