using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.UI.WebControls;

namespace SharpForge.Web.UI {

    /// <summary>
    /// An implementation of alistapart's sexy css buttons with modifcations to include an icon. 
    ///  http://www.oscaralexander.com/tutorials/how-to-make-sexy-buttons-with-css.html - sexy css buttons
    ///  http://www.famfamfam.com/lab/icons/silk/ - silky icons
    /// 
    /// The icon is displayed in front of the text. 
    ///   Our button is a basic <a> tag with a nested <span>, each containing a different slice of the background image. 
    ///   Both clicked and unclicked button states are included in a single image. To switch between normal and pressed state, we shift the background image vertically, 
    ///   revealing the alternate button state. This CSS based approach allows us to perform the switch without the need for any JavaScript 
    ///   trickery.
    /// 
    /// The resulting html looks something like this:
    ///   <a href="http://localhost/SharpForge/p/SharpForge/WorkItem/AdvancedSearch.aspx" class="button"><span><img src="../../../Images/Icons/page_find.png" style="border-width:0px;" />&nbsp;Advanced Search</span></a>        
    /// </summary>
    public class SexyHyperLink : HyperLink {

        private Image icon = new Image();

        /// <summary>
        /// So we can set the icon image url from the asp.net tag
        /// </summary>
        public string ImageUrl {
            set { icon.ImageUrl = value; } 
        }


        /// <summary>
        /// The image to display before the text
        /// </summary>
        public Image Icon {
            get { return icon; }
            set { icon = value; }
        }

        /// <summary>
        /// </summary>
        /// <param name="writer"></param>
        protected override void Render(System.Web.UI.HtmlTextWriter writer) {

           writer.Write("<a");

            if (!string.IsNullOrEmpty(this.NavigateUrl)) {
                if (this.NavigateUrl.StartsWith("~"))
                    writer.WriteAttribute("href", this.ResolveClientUrl(this.NavigateUrl));
                else
                    writer.WriteAttribute("href", this.NavigateUrl);
            }

            if (!string.IsNullOrEmpty(this.CssClass))
                writer.WriteAttribute("class", this.CssClass);

            if (!string.IsNullOrEmpty(this.Target))
                writer.WriteAttribute("target", this.Target);

            foreach (string key in this.Attributes.Keys)
                writer.WriteAttribute(key, this.Attributes[key]);

            writer.Write(">"); 

            //sexy buttons need a span
            writer.Write("<span>");
            if (icon.ImageUrl.Length != 0 ) {
                icon.RenderControl(writer);
                writer.Write("&nbsp;");
            }
            this.RenderContents(writer);
            writer.Write("</span>");

            writer.Write("</a>");
        }
    }
}
