using System.ComponentModel;
using System.Drawing;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace CustomWebControls
{
    /// <summary>
    /// An extended Calendar that can select DateRanges as well as Dates
    /// </summary>
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:DateRangePicker runat=server></{0}:DateRangePicker>")]
    public class DateRangePicker : Calendar
    {
        static readonly TableItemStyle defaultSelectedDateRangeStyle = new TableItemStyle();


        static DateRangePicker()
        {
            //initialise a default colour for defaultSelectedDateRangeStyle
            defaultSelectedDateRangeStyle.BackColor = Color.LightSteelBlue;
        }

        TableItemStyle selectedDateRangeStyle = defaultSelectedDateRangeStyle;

        protected override void OnDayRender(TableCell cell, CalendarDay day)
        {
            if (SelectedDateRange.Contains(day.Date))
            {
                cell.ApplyStyle(selectedDateRangeStyle);
            }
        }

        protected override void OnSelectionChanged()
        {
            base.OnSelectionChanged();

            bool emptyDateRange = SelectedDateRange == DateRange.EMPTY;
            bool dateRangeAlreadyPicked = SelectedDateRange.TimeSpan.TotalDays > 1;

            if (emptyDateRange || dateRangeAlreadyPicked)
            {
                SelectedDateRange = DateRange.CreateDay(SelectedDate);
                //save this date as the first date in our date range
            }
            else
            {
                SelectedDateRange = SelectedDateRange.Include(DateRange.CreateDay(SelectedDate));
                //set the end date in our date range
            }
        }

        //DateRange gets stored in the viewstate since it's a property that needs to persist across page requests.
        [Browsable(false)]
        public DateRange SelectedDateRange
        {
            get { return (DateRange) (ViewState["SelectedDateRange"]??DateRange.EMPTY); }
            set { ViewState["SelectedDateRange"] = value; }
        }

        //SelectedDateRangeStyle goes into a private variable since this property is designed.
        [Category("Styles")]
        [Description("The Style that is aplied to cells within the selected Date Range")]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
        [NotifyParentProperty(true)]
        [PersistenceMode(PersistenceMode.InnerProperty)]
        public TableItemStyle SelectedDateRangeStyle
        {
            get { return selectedDateRangeStyle; }
            set { selectedDateRangeStyle = value; }
        }
    }
}