Imports System.ComponentModel

''' <summary>
''' A public enum accessed as EnumControls.GlobalEnum
''' </summary>
''' <remarks></remarks>
Public Enum GlobalEnum
    Red
    Green
    Blue
End Enum

''' <summary>
''' An enum with a description attribute on some of the values
''' </summary>
''' <remarks>
''' Description attribute allows you to specify the text used
''' in the names. Note the first item includes embedded HTML.
''' </remarks>
Public Enum BookRatingWithDescription
    <Description("A <b>great</b> book!")> GreatBook
    <Description("Enjoyable read")> Enjoyable
    <Description("Not bad - ok")> OK
    Poor
    <Description("Where's the shredder?")> Terrible
End Enum

Public Class Examples

    ''' <summary>
    ''' A nested enum inisde the Examples class.
    ''' </summary>
    ''' <remarks>
    ''' To use this Enum you must use 'EnumControls.Examples+InternalEnum'
    ''' </remarks>
    Public Enum InternalEnum
        ExampleOfCamelCase
        Value_with_Underscores
    End Enum

End Class
