using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;


namespace Avg.Controls
{
	public class Demo2 : System.Web.UI.Page
	{
		protected SmartPager PgrMain;
		protected DataGrid GrdMain;


		override protected void OnInit(EventArgs e)
		{
			this.Load += new System.EventHandler(this.Page_Load);
			base.OnInit(e);
		}

		
		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
				PopulateGrid();
		}


		void PopulateGrid()
		{
			string cs = string.Format("Provider=Microsoft.Jet.OLEDB.4.0; Data Source={0}", Server.MapPath("data.mdb"));
			string query = "select OrderId, Freight, ShipName from Orders order by ShipName";

			OleDbConnection conn = new OleDbConnection(cs);
			conn.Open();

			DataTable orders = new DataTable();
			OleDbDataAdapter adap = new OleDbDataAdapter(query, conn);
			adap.Fill(orders);

			conn.Close();

			GrdMain.DataSource = orders;
			DataBind();

			PgrMain.PageCount = GrdMain.PageCount;

			ArrayList tooltips = new ArrayList();
			for (int i=0; i<orders.Rows.Count; i += GrdMain.PageSize)
				tooltips.Add(orders.Rows[i]["ShipName"].ToString());
			PgrMain.SetTooltips( (string[])tooltips.ToArray(typeof(string)) );
		}

		
		protected void PgrMain_PageChanged(object sender, System.EventArgs e)
		{
			GrdMain.CurrentPageIndex = PgrMain.CurrentPage - 1;
			PopulateGrid();
		}

	}
}
