/*
 * Copyright  2006, Ashley van Gerven - ashley._v_g_@gmail.com (NB: remove '_' chars)
 * All rights reserved.
 *
 * Use of this script, with or without modification, is permitted
 * provided that the above copyright notice and disclaimer below is not removed.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

var SmartPagerID


function SmartPagerSelectPage(id, pageNo)
{
	if (eval(id + "$callJS") != "")
		eval(eval(id + "$callJS") + "('" + id + "', " + pageNo + ")")
	else
	{
		document.getElementById("hdn" + id).value = pageNo
		document.getElementById("hdn" + id).form.submit()
	}
}


function showPager(srcEl)
{
	document.getElementById('pgrLayer').style.left = parseInt(srcEl.offsetLeft)
	document.getElementById('pgrLayer').style.top = parseInt(srcEl.offsetTop)
	document.getElementById('pgrLayer').style.visibility='visible'
	document.getElementById('pgrLayer').getElementsByTagName("INPUT")[0].value = ''
	document.getElementById('pgrLayer').getElementsByTagName("INPUT")[0].style.backgroundColor = ""
	document.getElementById('pgrLayer').getElementsByTagName("INPUT")[0].style.color = ""
	document.getElementById('pgrLayer').getElementsByTagName("INPUT")[0].focus()
	updateLabel()
}


function goToPage()
{
	var tb = document.getElementById('pgrLayer').getElementsByTagName("INPUT")[0]
	var pagerPageCount = eval(SmartPagerID + "$pagerPageCount")

	if (parseInt(tb.value) != tb.value || parseInt(tb.value) > pagerPageCount)
	{
		tb.style.backgroundColor = "#c00"
		tb.style.color = "white"
		tb.focus()
		return
	}

	tb.blur()
	document.getElementById('pgrLayer').style.visibility='hidden'

	SmartPagerSelectPage(SmartPagerID, tb.value)
}


function pagerTbKd(e)
{
	var tb = document.getElementById('pgrLayer').getElementsByTagName("INPUT")[0]
	var pagerPageCount = eval(SmartPagerID + "$pagerPageCount")

	tb.style.backgroundColor = ""
	tb.style.color = ""

	if (e.keyCode == 27) // escape key: hide layer
	{
		tb.blur()
		document.getElementById('pgrLayer').style.visibility='hidden'
	}
	else if (e.keyCode == 13) // Enter key
	{
		goToPage()

		if (window.event)  // IE
			e.returnValue = false
		else
			e.preventDefault()
	}
	else if (e.keyCode == 38) // up key
	{
		var current = (isNaN(parseInt(tb.value))) ? 0 : parseInt(tb.value)
		if (current < 1)
			tb.value = 1
		else if (current < pagerPageCount)
			tb.value = current + 1
		else
			tb.value = pagerPageCount

		updateLabel(parseInt(tb.value))
	}
	else if (e.keyCode == 40) // down key
	{
		var current = (isNaN(parseInt(tb.value))) ? 2 : parseInt(tb.value)
		if (current > 1)
			tb.value = current - 1
		else if (current > pagerPageCount)
			tb.value = pagerPageCount
		else
			tb.value = 1

		updateLabel(parseInt(tb.value))
	}
	else
		setTimeout("updateLabel()", 50)
}


function pagerPreventSubmit(e)
{
	if (e.keyCode == 13) // for opera - ensure Enter doesn't submit the form (keypress event handler)
	{
		if (window.event)  // IE
			e.returnValue = false
		else
			e.preventDefault()
	}
	else // cancel any letters etc for the number-only textbox
	{
		if (window.event) // IE & Opera
		{
			if (e.keyCode < 48 || e.keyCode > 57)
				e.returnValue = false
		}
		else // Mozilla
		{
			// keyCode == 0 means alphanumeric key pressed
			if (e.keyCode == 0 && (e.charCode < 48 || e.charCode > 57))
				e.preventDefault()
		}
	}
}


function updateLabel()
{
	var tb = document.getElementById('pgrLayer').getElementsByTagName("INPUT")[0]
	var pagerPageCount = eval(SmartPagerID + "$pagerPageCount")
	var current = parseInt(tb.value)

	// ensure that the TB contains only numbers and is a valid page number
	if (!isNaN(current) && current == tb.value && current > 0 && current <= pagerPageCount)
	{
		var tooltipText = eval(SmartPagerID + "$tooltipsArr[" + (current - 1) + "]") + ""
		if (tooltipText != "undefined" && tooltipText.length > 0)
		{
			document.getElementById("pgrPreviewLabel").innerHTML = tooltipText
			document.getElementById("pgrPreviewLabel").style.marginTop = "3px"
			return
		}
	}

	// reset
	document.getElementById("pgrPreviewLabel").innerHTML = "<img src=images/spacer.gif width=1 height=1><br>"
	document.getElementById("pgrPreviewLabel").style.marginTop = "0"
}


// output go-to-page layer
document.write("<style type=text/css>input.tbGoToPage { width:26px; font-size:11px; text-align:right; color:blue; background:#ddd; border-width:0 }</style>")
document.write("<div style=\"position:absolute; left:-200; top:-200; z-index:100; border:1px dashed gray; padding:5px; background-color:#eeeeee; visibility:hidden\" id=pgrLayer>"
+ "<span style=\"color:#555;font-size:10px\" id=smartPagerPageLabel>Page:</span><input type=text onkeydown=pagerTbKd(event) onkeypress=pagerPreventSubmit(event) autocomplete=off class=tbGoToPage><a href=# onclick=\"goToPage();return false\" style=text-decoration:none><span style=\"color:#444;font-size:11px;font-family:verdana;font-weight:bold;padding:0 2 1 2;border:1px solid #444;background:#FFFF99;margin-left:2px\" id=smartPagerGoLabel>GO</span></a>"
+ "&nbsp;&nbsp;<a href=# onclick=\"document.getElementById('pgrLayer').style.visibility='hidden';return false\" style=text-decoration:none><span style=\"color:white;font-size:11px;font-family:verdana;font-weight:bold;padding:0 2 1 2;border:0px solid #444;background:#c00\">X</span></a>"
+ "<div style=\"font-size:11px;font-family:arial\" id=pgrPreviewLabel></div></div>")