using System;
using System.ComponentModel;
using System.Data;

namespace TestWeb
{
	/// <summary>
	/// Dummy data class.
	/// </summary>
	[DataObject]
	public class SomeData
	{
		private static DataTable data;

		static SomeData()
		{
			// Initialise data
			data = new DataTable();
			data.Columns.Add("Id", typeof(int));
			data.Columns.Add("Name", typeof(string));
			data.Columns.Add("StockLevel", typeof(int));
			data.PrimaryKey = new DataColumn[] { data.Columns[0] };
			data.Rows.Add(new object[] { 1, "Pants", 1450 });
			data.Rows.Add(new object[] { 2, "Socks", 543 });
			data.Rows.Add(new object[] { 3, "Hats", 26 });
			data.Rows.Add(new object[] { 4, "Shoes", 341 });
			data.Rows.Add(new object[] { 5, "Belts", 897213 });
			data.Rows.Add(new object[] { 6, "Gloves", 217 });
			data.Rows.Add(new object[] { 7, "Ties", 6812 });
			data.Rows.Add(new object[] { 8, "Shorts", 6854432 });
			data.Rows.Add(new object[] { 9, "Shirts", 703354 });
			data.Rows.Add(new object[] { 10, "Jackets", 68045 });
		}

		/// <summary>
		/// Gets the data.
		/// </summary>
		[DataObjectMethod(DataObjectMethodType.Select)]
		public DataTable GetData()
		{
			return data;
		}

		/// <summary>
		/// Gets the number of entries.
		/// </summary>
		public int GetCount()
		{
			return data.Rows.Count;
		}

		/// <summary>
		/// Adds an entry.
		/// </summary>
		[DataObjectMethod(DataObjectMethodType.Insert)]
		public void Insert(string name, int stockLevel)
		{
			data.Rows.Add(new object[] { data.Rows.Count + 1, name, stockLevel });
		}

		/// <summary>
		/// Updates an entry.
		/// </summary>
		[DataObjectMethod(DataObjectMethodType.Update)]
		public void Update(int id, string name, int stockLevel)
		{
			DataRow row = data.Select("Id=" + id)[0];
			row["Name"] = name;
			row["StockLevel"] = stockLevel;
		}

		/// <summary>
		/// Deletes an entry.
		/// </summary>
		[DataObjectMethod(DataObjectMethodType.Delete)]
		public void Delete(int id)
		{
			data.Select("Id=" + id)[0].Delete();
		}
	}
}
