using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace TestWeb
{
	/// <summary>
	/// An extended <see cref="CommandField"/> that allows deletions
	/// to be confirmed by the user.
	/// </summary>
	public class ExtendedCommandField : CommandField
	{
		/// <summary>
		/// Initialise the cell.
		/// </summary>
		public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex)
		{
			base.InitializeCell(cell, cellType, rowState, rowIndex);
			if (!string.IsNullOrEmpty(this.DeleteConfirmationText) && this.ShowDeleteButton)
			{
				foreach (Control control in cell.Controls)
				{
					IButtonControl button = control as IButtonControl;
					if (button != null && button.CommandName == "Delete")
						// Add delete confirmation
						((WebControl)control).Attributes.Add("onclick", string.Format("if (!confirm('{0}')) return false;", this.DeleteConfirmationText));
				}
			}
		}

		#region Properties

		#region DeleteConfirmationText
		/// <summary>
		/// Delete confirmation text.
		/// </summary>
		[Category("Behavior")]
		[Description("The text shown to the user to confirm the deletion.")]
		public string DeleteConfirmationText
		{
			get { return this.ViewState["DeleteConfirmationText"] as string; }
			set { this.ViewState["DeleteConfirmationText"] = value; }
		}
		#endregion

		#endregion
	}
}
