using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;
using System.ComponentModel;
[System.ComponentModel.Description("Hello World Demo")]
public partial class NotesControl : System.Web.UI.UserControl
{
  
    private string Txt="Notes";
    private string Desc="Notes Description";
    private Color backColor=System.Drawing.Color.LightGray ;
    private string iPath = "Notes.gif";
    private String notesSize="Medium";
    private int _LineLength = 0;
    public int Result;


    
    #region PropertySet
    //Property for Set Notes Size
    //It either Short, Long or Medium
    public String NotesSize
    {
        
        get
        {
            return notesSize; 
        }
        set
        {
            notesSize = value;
        }
    }
    //Property For Header Text
    public string HeaderText
    {
        get
        {
            return Txt; 
          
        }
        set
        {
            Txt = value;
        }
    }
    //Property For Description
   public string Description
    {
        get
        {
            return Desc ;
        }
        set
        {
            Desc  = value;
        }
    }
    //Property For Backcolor
   public Color BackColor
    {
     get
     {
         return backColor; 
     }
      set
      {
          backColor = value; 
      }
     }
    //Property For ImagePath
    public string imagePath
    {
        get
        {
            return iPath;
        }
        set
        {
            iPath = value;
        }
    }
    #endregion

    protected void Page_Load(object sender, EventArgs e)
    {
        //Calculation the Length
         int Factor;
        _LineLength =  Desc.Length;
        switch (notesSize)
        {
             case  "Short":
                Result = _LineLength / 38;
                break;
            case "Medium":
                Result=_LineLength/68;
                break;
            case "Long":
                Result= _LineLength/98;
                break;
        } 

       if (Result == 0)
            Factor = 1;
        else
            Factor = 24 * Result;



        this.Label1.Text = Txt;
        this.Label2.Text = Desc;
        this.Image1.ImageUrl =imagePath; 
        this.Label1.BackColor = backColor; 
        this.Panel1.BackColor = backColor;
        this.Panel1.BorderColor = backColor;
        if (notesSize.Equals("Medium"))
        {
            this.Panel1.Height = 56 + Factor;
            this.Label2.Height = 24 + Factor;
            this.Panel1.Width = 440;
            this.Label1.Width = 422;
            this.Label2.Width = 440;
        }

        if (notesSize.Equals("Short"))
        {
            this.Panel1.Height = 56 + Factor;
            this.Label2.Height = 24+Factor;
            this.Panel1.Width = 240;
            this.Label1.Width = 222;
            this.Label2.Width = 240;
        }
        
        if (notesSize.Equals("Long"))
        {
            this.Panel1.Height = 56 + Factor;
            this.Label2.Height = 24 + Factor;
            this.Panel1.Width = 640;
            this.Label1.Width = 622;
            this.Label2.Width = 640;
        }
     }
}
