using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections;

public partial class Example8 : System.Web.UI.Page 
{
	private TableCell[] _gvTest1HeaderCells = new TableCell[4];

    protected void Page_Load(object sender, EventArgs e)
    {
		this.gvTest1.DataBinding += new EventHandler(gvTest1_DataBinding);
		this.gvTest1.RowDataBound += new GridViewRowEventHandler(gvTest1_RowDataBound);
		this.gvTest1.PageIndexChanging += new GridViewPageEventHandler(gvTest1_PageIndexChanging);
		this.gvTest1.DataBound += new EventHandler(gvTest1_DataBound);
		LoadGridView(this.gvTest1.PageIndex);
    }

	void gvTest1_DataBound(object sender, EventArgs e)
	{
		int r = 0;
		int c = 0;
		string id = string.Empty;
		string ids = string.Empty;
		VwdCms.SplitterBar sb = null;
		for (c = 0; c < 4; c++)
		{
			ids = string.Empty;
			for (r = 0; r < this.gvTest1.Rows.Count; r++)
			{
				id = "gvTest1_r" + r.ToString() + "_c" + c.ToString();
				ids += id + ";";
			}
			sb = (VwdCms.SplitterBar)this.FindControl("vwdSplitter" + c.ToString());
			if (sb != null)
			{
				id = "gvTest1_r0_c" + c.ToString();
				sb.LeftResizeTargets = id + ";" + ids;
			}
		}
	}

	protected override void OnPreRender(EventArgs e)
	{
		// since the IDs of the column header cells are not set when the form 
		// loads and postbacks, need to force the resizing here before the page renders
		if (this.Page.IsPostBack)
		{
			_gvTest1HeaderCells[0].Width = new Unit(this.vwdSplitter0.LeftColumnWidth);
			_gvTest1HeaderCells[1].Width = new Unit(this.vwdSplitter1.LeftColumnWidth);
			_gvTest1HeaderCells[2].Width = new Unit(this.vwdSplitter2.LeftColumnWidth);
			_gvTest1HeaderCells[3].Width = new Unit(this.vwdSplitter3.LeftColumnWidth);
		}

		base.OnPreRender(e);
	}

	void gvTest1_PageIndexChanging(object sender, GridViewPageEventArgs e)
	{
		LoadGridView(e.NewPageIndex);
	}

	void LoadGridView(int pageIndex)
	{
		this.gvTest1.PageIndex = pageIndex;

		// load the data for the gridview
		ArrayList rows = new ArrayList();
		int r = 0;
		int c = 0;

		GridViewRowData gvrd = null;
		for (r = 0; r < 20; r++)
		{
			gvrd = new GridViewRowData();
			for (c = 0; c < 4; c++)
			{
				gvrd.Cols[c] = "[" + r.ToString() + ", " + c.ToString() + "] some more text to make it longer";
			}
			rows.Add(gvrd);
		}

		this.gvTest1.DataSource = rows;
		this.gvTest1.DataBind();

	}

	void gvTest1_RowDataBound(object sender, GridViewRowEventArgs e)
	{
		if (e != null && e.Row != null )
		{
			if (e.Row.RowType == DataControlRowType.Header)
			{
				TableRow tr = null;
				TableCell tc = null;

				int c = 0;

				for (c = 0; c < 4; c++)
				{
					tr = e.Row;
					tr.ID = "hr" + e.Row.RowIndex.ToString();
					tc = tr.Cells[c];
					tc.ID = "hc" + c.ToString();
					if (!this.Page.IsPostBack)
					{
						tc.Width = new Unit("120px");
					}
					tc.Attributes.Add("onresize", "VwdCmsSplitterBar.reconfigure();");
					_gvTest1HeaderCells[c] = tc;
				}
			}
			else if (e.Row.RowType == DataControlRowType.DataRow)
			{

				GridViewRowData gvrd = null;
				if (e.Row.DataItem != null)
				{
					gvrd = e.Row.DataItem as GridViewRowData;
				}

				TableRow tr = null;
				TableCell tc = null;

				int c = 0;

				for (c = 0; c < 4; c++)
				{
					tr = e.Row;
					tr.ID = "r" + e.Row.RowIndex.ToString();
					tc = tr.Cells[c];
					tc.ID = "c" + c.ToString();
					if (gvrd != null)
					{
						tc.Text = gvrd.Cols[c];
					}
				}
			}
		}
	
	}

	void gvTest1_DataBinding(object sender, EventArgs e)
	{
		

	}
}

public class GridViewRowData
{
	public string Col0 = string.Empty;
	public string Col1 = string.Empty;
	public string Col2 = string.Empty;
	public string Col3 = string.Empty;
	public string[] Cols = null; // new string[4];

	public GridViewRowData()
	{
		this.Cols = new string[] { this.Col0, this.Col1, this.Col2, this.Col3 };
	}
	public GridViewRowData(string col0, string col1, string col2, string col3 )
	{
		this.Cols = new string[] { this.Col0, this.Col1, this.Col2, this.Col3 };

		this.Col0 = col0;
		this.Col1 = col1;
		this.Col2 = col2;
		this.Col3 = col3;
	}
}
