<!--
//---------------------------------------------------
//     Copyright (c) 2007 Jeffrey Bazinet, VWD-CMS 
//     http://www.vwd-cms.com/  All rights reserved.
//---------------------------------------------------
-->

<%@ Page 
Language="C#" 
AutoEventWireup="true" 
CodeFile="Example10.aspx.cs" 
Inherits="Example10"
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head runat="server">
    <title>Example 10: VwdCms Vertical and Horizontal SplitterBars together</title>   
<script type="text/javascript"> 
<!-- #include virtual="VwdCmsSplitterBar.js" -->
</script> 
<!--     <script src="VwdCmsSplitterBar.js" type="text/javascript"></script> -->

<script language="javascript" type="text/javascript"><!--

	function splitterOnResize(splitterBar, width)
	{
		// do any other work that needs to happen when the 
		// splitter resizes. this is a good place to handle 
		// any complex resizing rules, etc.


		// if the vertical splitter fired this event, 
		// resize the right side and reconfigure the horizontal splitter
		if ( splitterBar && splitterBar.id == "vsbSplitter" )
		{
			// make sure the width is in number format
			if (typeof width == "string")
			{
				width = new Number(width.replace("px",""));
			}
			// the default resizing works fine for firefox, but not on IE 7
			if(_isIE)
			{
				var rightWidth = splitterBar.totalWidth-width-splitterBar.splitterWidth;
				
//				document.getElementById("tdRight").style.width = rightWidth + "px";
//				document.getElementById("tblRight").style.width = rightWidth + "px";
				document.getElementById("tdTop").style.width = rightWidth + "px";
				document.getElementById("tdBottom").style.width = rightWidth + "px";


				var divWidth = rightWidth-10; // adjust for IE borders
				document.getElementById("divTop").style.width = divWidth + "px";
				document.getElementById("divBottom").style.width = divWidth + "px";
			}

			if(sbar_hsbSplitter != null)
			{
				sbar_hsbSplitter.configure();
			}
		}
	}


	function simulateDoubleClick(splitter)
	{
		if(_isIE)
		{
			splitter.splitterBar.fireEvent('ondblclick');
		}
		else
		{
			var evnt=document.createEvent('MouseEvents');
			evnt.initEvent('dblclick',true,true);
			splitter.splitterBar.dispatchEvent(evnt);
		}
	}

	function setMinWidth(splitter, minwidth)
	{
		splitter.minWidth = getInt(minwidth);
		if ( splitter.hdnMinWidth )
		{
			splitter.hdnMinWidth.value = splitter.minWidth + "px";
		}
		var width = getInt(splitter.splitterBar.style.left) - getInt(splitter.offsetLeft);
		if(width < getInt(minwidth))
		{
			splitter.splitterBar.style.left = getInt(minwidth) + getInt(splitter.offsetLeft) + "px";
			VwdCmsSplitterBar_setTargetWidth(splitter);
		}
	}

	function setMaxWidth(splitter, maxwidth)
	{
		splitter.maxWidth = getInt(maxwidth);
		if ( splitter.hdnMaxWidth )
		{
			splitter.hdnMaxWidth.value = splitter.maxWidth + "px";
		}
		var width = getInt(splitter.splitterBar.style.left) - getInt(splitter.offsetLeft);
		if(width > getInt(maxwidth))
		{
			splitter.splitterBar.style.left = getInt(maxwidth) + getInt(splitter.offsetLeft) + "px";
			VwdCmsSplitterBar_setTargetWidth(splitter);
		}
	}

	function setMinHeight(splitter, minheight)
	{
		splitter.minHeight = getInt(minheight);
		if ( splitter.hdnMinHeight )
		{
			splitter.hdnMinHeight.value = splitter.minHeight + "px";
		}
		var height = getInt(splitter.splitterBar.style.top) - getInt(splitter.offsetTop);
		if(height < getInt(minheight))
		{
			splitter.splitterBar.style.top = getInt(minheight) + getInt(splitter.offsetTop) + "px";
			VwdCmsSplitterBar_setTargetHeight(splitter);
		}
	}

	function setMaxHeight(splitter, maxheight)
	{
		splitter.maxHeight = getInt(maxheight);
		if ( splitter.hdnMaxHeight )
		{
			splitter.hdnMaxHeight.value = splitter.maxHeight + "px";
		}
		var height = getInt(splitter.splitterBar.style.top) - getInt(splitter.offsetTop);
		if(height > getInt(maxheight))
		{
			splitter.splitterBar.style.top = getInt(maxheight) + getInt(splitter.offsetTop) + "px";
			VwdCmsSplitterBar_setTargetHeight(splitter);
		}
	}

// -->
</script>

</head>
<body style="margin:10px;padding:0px;">
    <form id="form1" runat="server">
    <div>
		<center>
		<table border="0" style="width:800px;background-color:gainsboro;border:solid 1px black;">
			<tr>
				<td align="left" valign="middle">
					<h1 style="font-family:Verdana;font-size:13pt;text-align:left;
						padding:5px;color:steelblue;">VwdCms.SplitterBar : Example 10 (Vertical and Horizontal SplitterBars)</h1>
				</td>
				<td align="right" valign="middle">
					<a href="http://www.vwd-cms.com/"><img 
					src="vwd-cms-logo-small.jpg" style="width:150px;height:32px;border:none;"
					alt="The VwdCms.SplitterBar has been provided by VWD-CMS.com." /></a>
				</td>
			</tr>
			<tr>
				<td colspan="2" align="center" valign="middle">
					<a href="Example1.aspx">Example 1</a>
					&nbsp;|&nbsp;
					<a href="Example2.aspx">Example 2</a>
					&nbsp;|&nbsp;
					<a href="Example3.aspx">Example 3</a>
					&nbsp;|&nbsp;
					<a href="Example4.aspx">Example 4</a>
					&nbsp;|&nbsp;
					<a href="Example5.aspx">Example 5</a>
					&nbsp;|&nbsp;
					<a href="Example6.aspx">Example 6</a>
					<br /> 
					<a href="Example7.aspx">Example 7</a>
					&nbsp;|&nbsp; 
					<a href="Example8.aspx">Example 8</a>
					&nbsp;|&nbsp; 
					<a href="Example9.aspx">Example 9 (Horizontal)</a>
					 &nbsp;|&nbsp;
					<a href="Example10.aspx">Example 10 (Vertical + Horizontal)</a>
				</td>
			</tr>
		</table>
		<br />
		<div style="width:800px;font-family:Verdana;font-size:8pt;text-align:left;
			padding:5px;background-color:#efefef;border:solid 1px silver;">
			This example demonstrates Vertical and Horizontal SplitterBars implemented together. 
			<br />
			<br />
		</div>
		<br />

		<table border="0" cellpadding="0" cellspacing="0" style="width:800px;height:406px;border:solid 5px lightsteelblue;overflow:hidden;">
			<tr id="trMain">
				<td runat="server" id="tdLeft" style="width:200px;height:406px;overflow:hidden;" align="left" valign="top"> 
					<div id="divLeft" style="background-color:lightgreen;height:100%;overflow:auto;"> 
						This example demonstrates Vertical and Horizontal SplitterBars implemented together.
						This example demonstrates Vertical and Horizontal SplitterBars implemented together.
						This example demonstrates Vertical and Horizontal SplitterBars implemented together.
						This example demonstrates Vertical and Horizontal SplitterBars implemented together.
						This example demonstrates Vertical and Horizontal SplitterBars implemented together.
					</div> 
				</td>
				<td style="width:6px;font-size:0pt;background-color:lightsteelblue;">&nbsp;</td>
				<td runat="server" id="tdRight" style="height:406px;overflow:hidden;" align="left" valign="top"> 
					<table id="tblRight" border="0" cellpadding="0" cellspacing="0" style="height:406px;border:none;overflow:hidden;">
						<tr id="trTop">
							<td runat="server" id="tdTop" style="height:200px;overflow:hidden;" align="left" valign="top"> 
								<div id="divTop" style="background-color:yellow;height:100%;overflow:auto;"> 
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
								</div> 
							</td>
						</tr>
						<tr style="height:6px;background-color:lightsteelblue;"><td style="height:6px;font-size:0pt;">&nbsp;</td></tr>
						<tr id="trBottom">
							<td runat="server" id="tdBottom" style="height:200px;overflow:hidden;" align="left" valign="top"> 
								<div id="divBottom" style="background-color:orange;height:100%;overflow:auto;"> 
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
									This example demonstrates Vertical and Horizontal SplitterBars implemented together.
								</div> 
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		
		<br />
		<span style="color:#336699;font-family:Verdana;font-size:10pt;font-weight:bold;">Vertical Splitter:</span>
		<span style="font-family:Verdana;font-size:10pt;font-weight:bold;">Min Width:</span>
		<input type="radio" runat="server" name="radMinWidth" value="20" id="radMinWidth20" checked onclick="setMinWidth(sbar_vsbSplitter,this.value);" /><label for="radMinWidth20">20</label>
		<input type="radio" runat="server" name="radMinWidth" value="100" id="radMinWidth100" onclick="setMinWidth(sbar_vsbSplitter,this.value);" /><label for="radMinWidth100">100</label>
		<input type="radio" runat="server" name="radMinWidth" value="200" id="radMinWidth200" onclick="setMinWidth(sbar_vsbSplitter,this.value);" /><label for="radMinWidth200">200</label>
		&nbsp;&nbsp;&nbsp;
		<span style="font-family:Verdana;font-size:10pt;font-weight:bold;">Max Width:</span>
		<input type="radio" runat="server" name="radMaxWidth" value="300" id="radMaxWidth300" onclick="setMaxWidth(sbar_vsbSplitter,this.value);" /><label for="radMaxWidth300">300</label>
		<input type="radio" runat="server" name="radMaxWidth" value="100" id="radMaxWidth500" onclick="setMaxWidth(sbar_vsbSplitter,this.value);" /><label for="radMaxWidth500">500</label>
		<input type="radio" runat="server" name="radMaxWidth" value="760" id="radMaxWidth760" checked onclick="setMaxWidth(sbar_vsbSplitter,this.value);" /><label for="radMaxWidth760">760</label>
		<br />
		<br />

		<span style="color:#336699;font-family:Verdana;font-size:10pt;font-weight:bold;">Horizontal Splitter:</span>
		<span style="font-family:Verdana;font-size:10pt;font-weight:bold;">Min Height:</span>
		<input type="radio" runat="server" name="radMinHeight" value="30" id="radMinHeight30" checked onclick="setMinHeight(sbar_hsbSplitter,this.value);" /><label for="radMinHeight30">30</label>
		<input type="radio" runat="server" name="radMinHeight" value="100" id="radMinHeight100" onclick="setMinHeight(sbar_hsbSplitter,this.value);" /><label for="radMinHeight100">100</label>
		<input type="radio" runat="server" name="radMinHeight" value="200" id="radMinHeight200" onclick="setMinHeight(sbar_hsbSplitter,this.value);" /><label for="radMinHeight200">200</label>
		&nbsp;&nbsp;&nbsp;
		<span style="font-family:Verdana;font-size:10pt;font-weight:bold;">Max Height:</span>
		<input type="radio" runat="server" name="radMaxHeight" value="250" id="radMaxHeight250" onclick="setMaxHeight(sbar_hsbSplitter,this.value);" /><label for="radMaxHeight250">250</label>
		<input type="radio" runat="server" name="radMaxHeight" value="300" id="radMaxHeight300" onclick="setMaxHeight(sbar_hsbSplitter,this.value);" /><label for="radMaxHeight300">300</label>
		<input type="radio" runat="server" name="radMaxHeight" value="370" id="radMaxHeight370" checked onclick="setMaxHeight(sbar_hsbSplitter,this.value);" /><label for="radMaxHeight370">370</label>
		<br />
		<br />

		<span style="font-family:Verdana;font-size:10pt;font-weight:bold;">Current Width:</span>
		<asp:textbox runat="server" id="txtWidth" Text="200px" style="width:70px;font-family:Verdana;font-size:10pt;"/>
		&nbsp;&nbsp;&nbsp;
		<span style="font-family:Verdana;font-size:10pt;font-weight:bold;">Current Height:</span>
		<asp:textbox runat="server" id="txtHeight" Text="200px" style="width:70px;font-family:Verdana;font-size:10pt;"/>
		<br />
		<br />
		<asp:Button runat="server" ID="btnPostBack" Text="Test PostBack" />
		&nbsp;&nbsp;&nbsp;
		<input type="button" id="btnDblClick"  value="Simulate a Double Click (vertical)"
		onclick="simulateDoubleClick(sbar_vsbSplitter);" />
		<br />
		<br />
		<asp:Button runat="server" ID="btnSetWidth" Text="Set Width to 300 via PostBack" />
		&nbsp;&nbsp;&nbsp;
		<asp:Button runat="server" ID="btnSetHeight" Text="Set Height to 300 via PostBack" />
		&nbsp;&nbsp;&nbsp;

		<br />
		<br />
		Check the check box below to enable debugging output.<br />
		<b>Note:</b> Outputting debugging information severely slows down the UI performance of the 
		SplitterBar. <br />
		<input type="checkbox" runat="server" id="chkDebug" 
		onclick="var txt=null;if (this.checked){txt='txtDebug';} VwdCmsSplitterBar.setDebug(txt, '');"/>
		Debugging Output: (newest events on the top)
		&nbsp;&nbsp;&nbsp;&nbsp;
		<input type="button" value="Clear" onclick="document.getElementById('txtDebug').value='';"
		style="height:20px;width:45px;font-family:arial;font-size:8pt;" />
		&nbsp;&nbsp;
		<input type="submit" value="Reload" 
		style="height:20px;width:45px;font-family:arial;font-size:8pt;" />
		<br />
		<textarea id="txtDebug" cols="60" rows="8"></textarea>

		<VwdCms:SplitterBar runat="server" ID="hsbSplitter" Orientation="horizontal" 
			TopResizeTargets="tdTop" 
			BottomResizeTargets="tdBottom" 
			MinHeight="30" 
			MaxHeight="370"
			TotalHeight="406" 
			BackgroundColor="lightsteelblue" 
			BackgroundColorLimit="firebrick"
			BackgroundColorHilite="steelblue"
			BackgroundColorResizing="purple"
			SaveHeightToElement="txtHeight"
			style="background-image:url(hsplitter.gif);
				background-position:center center;
				background-repeat:no-repeat;"/>
		<VwdCms:SplitterBar runat="server" ID="vsbSplitter" Orientation="vertical" 
			LeftResizeTargets="tdLeft;divLeft" 
			OnResize="splitterOnResize" 
			MinWidth="20" 
			MaxWidth="760"
			TotalWidth="800" 
			BackgroundColor="lightsteelblue" 
			BackgroundColorLimit="firebrick"
			BackgroundColorHilite="steelblue"
			BackgroundColorResizing="purple"
			SaveWidthToElement="txtWidth"
			style="background-image:url(vsplitter.gif);
				background-position:center center;
				background-repeat:no-repeat;"/> 
				
<%--

DebugElement="txtDebug"
OnResize="splitterOnResize" 
TopResizeTargets="tdTop;trTop" 
BottomResizeTargets="tdBottom;trBottom" 
--%>

	</center>
    </div>
    </form>
</body>
</html>
