using System;
using System.Collections;
using System.Data;
using System.Web;
using System.Web.UI;

namespace doug.Components
{
	#region Tab Class
	//Single Tab Class

	public class Tab 
	{
	#region Constructors
		public Tab() 
		{
			//Default Constructor
		}

		public Tab(string strID) 
		{
			m_ID = strID;
		}

		public Tab(string strID, string strName) 
		{
			m_ID = strID;
			m_dispName = strName;
		}

		public Tab(string strID, string strName, int intWeight) 
		{
			m_ID = strID;
			m_dispName = strName;
			m_weight = intWeight;
		}

		public Tab(string strName, int intWeight, string strPanel) 
		{
			m_dispName = strName;
			m_weight = intWeight;
			m_panel = strPanel;
		}

	#endregion
	#region Tab Members & Properties
		string m_ID = "";
		string m_dispName = "";
		int m_weight = 0;
		string m_panel = "";
		string m_url = "";

		public string ID 
		{
			get { return m_ID; }
			set { m_ID = value; }
		}

		public string DisplayName 
		{
			get { return m_dispName; }
			set { m_dispName = value; }
		}

		public int DisplayPosition 
		{
			get { return m_weight; }
			set { m_weight = value; }
		}

		public string LinkedToPanel 
		{
			get { return m_panel; }
			set { m_panel = value; }
		}

		public string URL 
		{
			get {return m_url; }
			set { m_url = value; }
		}
	#endregion
	}

	#endregion
	#region TabList Class

	public class TabList : Control, INamingContainer
	{
		protected class TabCompare : IComparer 
		{
			public int Compare(object x, object y) 
			{
				Tab tx = (Tab)x;
				Tab ty = (Tab)y;
				if (tx.DisplayPosition > ty.DisplayPosition) 
				{
					return 1;
				}
				else if (tx.DisplayPosition == ty.DisplayPosition) 
				{
					return 0;
				}
				else 
				{
					return -1;
				}
			}
		}

		public TabList()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		#region Members & Properties
		enum tabSelType 
		{
			ID,
			DisplayName,
			Weight
		}

		bool m_bolUseFrames = true;
		
		string m_strTargetFrame = "";
		string m_strLeftImage = "";
		string m_strRightImage = "";
		string m_strTopImage = "";
		string m_strBottomImage = "";
		string m_strSelLeftImage = "";
		string m_strSelRightImage = "";
		string m_strSelTopImage = "";
		string m_strSelBottomImage = "";
		string m_CssClass = "";
		string m_SelCssClass = "";
		
		int m_intSelTab = 0;
		int m_intTabsAcross = 5;

		ArrayList m_items = new ArrayList();

		public bool UseFrames 
		{
			get { return m_bolUseFrames; }
			set { m_bolUseFrames = value; }
		}

		public string TargetFrame 
		{
			get { return m_strTargetFrame; }
			set { m_strTargetFrame = value; }
		}
		public string LeftImage 
		{
			get { return m_strLeftImage; }
			set { m_strLeftImage = value; }
		}

		public string RightImage 
		{
			get { return m_strRightImage; }
			set { m_strRightImage = value; }
		}
		public string TopImage 
		{
			get { return m_strTopImage; }
			set { m_strTopImage = value; }
		}
		public string BottomImage 
		{
			get { return m_strBottomImage; }
			set { m_strBottomImage = value; }
		}
		public string LeftImageOver 
		{
			get { return m_strSelLeftImage; }
			set { m_strSelLeftImage = value; }
		}
		public string RightImageOver 
		{
			get { return m_strSelRightImage; }
			set { m_strSelRightImage = value; }
		}
		public string TopImageOver 
		{
			get { return m_strSelTopImage; }
			set { m_strSelTopImage = value; }
		}
		public string BottomImageOver 
		{
			get { return m_strSelBottomImage; }
			set { m_strSelBottomImage = value; }
		}


		public string CssClass 
		{
			get { return m_CssClass; }
			set { m_CssClass = value; }
		}
		public string CssClassOver 
		{
			get { return m_SelCssClass; }
			set { m_SelCssClass = value; }
		}


		public int SelectedTab 
		{
			get { return m_intSelTab; }
			set { m_intSelTab = value; }
		}
		public int TabsAcross 
		{
			get { return m_intTabsAcross; }
			set { m_intTabsAcross = value; }
		}
		#endregion
		#region Methods
		//Adds an item to the List
		public void AddTab(Tab myTab) 
		{
			m_items.Add(myTab);
		}
		//Sorts the items in the list into display order
		private void order() 
		{
			m_items.Sort(new TabCompare());
		}

		//Returns the URL of the selected Tab
		private string GetTabURL(int intDispPos) 
		{
			string URL = "";
			foreach (Tab myTab in m_items) 
			{
				if (myTab.DisplayPosition == intDispPos) 
				{
					URL = myTab.URL;
				}
			}
			return URL;
		}

		//Resets the selected Tab and fires selected page
		private void ChangeTab(object sender, EventArgs E) 
		{
			CreateChildControls();
			m_intSelTab = Convert.ToInt32(((System.Web.UI.WebControls.LinkButton)sender).ID.ToString());
			string strBuildUp = "<script language=JavaScript>";
			strBuildUp += "window.onload = window.parent.frames[\"" + m_strTargetFrame;
			strBuildUp += "\"].location.replace(\"" + GetTabURL(m_intSelTab) + "\");" + "\n";
			strBuildUp += "<";
			strBuildUp += "/";
			strBuildUp += "script>";
			Page.Response.Write(strBuildUp);
			CreateChildControls();
		}

		//Returns the colspan for each tab
		private int GetTabColspan() 
		{
			int intColspan = 1;
			if (m_strLeftImage.Length > 0) 
			{ intColspan++; }
			if (m_strRightImage.Length > 0)
			{ intColspan++; }
			return intColspan;
		}

		//Returns render string for top image row 
		private string TopRow(int intStart,ref int intFinish, int intSelected) 
		{
			//intStart is the first tab index to display
			//intFinish is the last tab index displayed
			//intSelected is the currently selected tab

			int intTabspan = 0;
			string strReturn = "<tr>";

			//Set how many tabs to go across the page
			if (m_intTabsAcross <= m_items.Count) 
			{ intTabspan = m_intTabsAcross; }
			else { intTabspan = m_items.Count; }

			//Build up display string
			for (int i=0; i < intTabspan; i++) 
			{
				if (m_items.Count > (intStart+i)) 
				{
					Tab myTab = (Tab)m_items[i+intStart];
					if (intSelected == myTab.DisplayPosition)
					{
						strReturn += "<td colspan=\"" + GetTabColspan().ToString() + "\" class=\"" + m_CssClass + "\">";
						strReturn += "<img border=\"0\" src=\"" + m_strTopImage + "\">";
						strReturn += "</td>";
					}
					else 
					{
						strReturn += "<td colspan=\"" + GetTabColspan().ToString() + "\" class=\"" + m_SelCssClass + "\">";
						strReturn += "<img border=\"0\" src=\"" + m_strSelTopImage + "\">";
						strReturn += "</td>";
					}
				}
				intFinish++;
			}

			strReturn += "</tr>";
			return strReturn;
		}

		//Returns render string for content row
		private void MiddleRow(int intStart,ref int intFinish, int intSelected) 
		{
			//intStart is the first tab index to display
			//intFinish is the last tab index displayed
			//intSelected is the currently selected tab

			int intTabspan = 0;
			this.Controls.Add(new LiteralControl("<tr>"));

			//Set how many tabs to go across the page
			if (m_intTabsAcross <= m_items.Count) 
			{ intTabspan = m_intTabsAcross; }
			else { intTabspan = m_items.Count; }

			//Build up display string
			for (int i=0; i < intTabspan; i++) 
			{
				if (m_items.Count > (intStart+i)) 
				{
					Tab myTab = (Tab)m_items[i+intStart];

					if (intSelected == myTab.DisplayPosition) 
					{
						//Left Image if necessary
						if (GetTabColspan() > 1) 
						{
							this.Controls.Add(new LiteralControl("<td class=\""	+ m_SelCssClass + "\"><img src=\"" + m_strSelLeftImage + "\"></td>"));
						}

						//Using Frames??
						if (m_bolUseFrames) 
						{
							System.Web.UI.WebControls.LinkButton btnLink = new System.Web.UI.WebControls.LinkButton();
							btnLink.Text = myTab.DisplayName;
							btnLink.Click += new EventHandler(ChangeTab);
							btnLink.ID = myTab.DisplayPosition.ToString();
							btnLink.CssClass = "TabSelLink";
							this.Controls.Add(new LiteralControl("<td class=\"" + m_SelCssClass + "\">"));
							this.Controls.Add(btnLink);
							this.Controls.Add(new LiteralControl("</td>"));
						}
						else { this.Controls.Add(new LiteralControl("<td class=\"" + m_SelCssClass + "\">" + myTab.DisplayName + "</td>")); }

						//Right Image if necessary
						if (GetTabColspan() > 2) 
						{
							this.Controls.Add(new LiteralControl("<td class=\"" + m_SelCssClass + "\"><img src=\"" + m_strSelRightImage + "\"></td>"));
						}
					}
					else 
					{
					
						if (GetTabColspan() > 1) 
						{
							this.Controls.Add(new LiteralControl("<td class=\""	+ m_CssClass + "\"><img src=\"" + m_strLeftImage + "\"></td>"));
						}

						//Using Frames??
						if (m_bolUseFrames) 
						{
							System.Web.UI.WebControls.LinkButton btnLink = new System.Web.UI.WebControls.LinkButton();
							btnLink.Text = myTab.DisplayName;
							btnLink.Click += new EventHandler(ChangeTab);
							btnLink.ID = myTab.DisplayPosition.ToString();
							btnLink.CssClass = "TabLink";
							this.Controls.Add(new LiteralControl("<td class=\"" + m_CssClass + "\">"));
							this.Controls.Add(btnLink);
							this.Controls.Add(new LiteralControl("</td>"));
						}
						else { this.Controls.Add(new LiteralControl("<td class=\"" + m_CssClass + "\">" + myTab.DisplayName + "</td>")); }
						

						if (GetTabColspan() > 2) 
						{
							this.Controls.Add(new LiteralControl("<td class=\"" + m_CssClass + "\"><img src=\"" + m_strRightImage + "\"></td>"));
						}
					}
				}
				intFinish++;
			}

			this.Controls.Add(new LiteralControl("</tr>"));
		}

		//Returns render string for bottom image row
		private string BottomRow(int intStart,ref int intFinish, int intSelected) 
		{
			//intStart is the first tab index to display
			//intFinish is the last tab index displayed
			//intSelected is the currently selected tab

			int intTabspan = 0;
			string strReturn = "<tr>";

			//Set how many tabs to go across the page
			if (m_intTabsAcross <= m_items.Count) 
			{ intTabspan = m_intTabsAcross; }
			else { intTabspan = m_items.Count; }

			//Build up display string
			for (int i=0; i < intTabspan; i++) 
			{
				if (m_items.Count > (intStart+i)) 
				{
					Tab myTab = (Tab)m_items[i+intStart];
					if (intSelected == myTab.DisplayPosition)
					{
						strReturn += "<td colspan=\"" + GetTabColspan().ToString() + "\" class=\"" + m_CssClass + "\">";
						strReturn += "<img border=\"0\" src=\"" + m_strBottomImage + "\">";
						strReturn += "</td>";
					}
					else 
					{
						strReturn += "<td colspan=\"" + GetTabColspan().ToString() + "\" class=\"" + m_SelCssClass + "\">";
						strReturn += "<img border=\"0\" src=\"" + m_strSelBottomImage + "\">";
						strReturn += "</td>";
					}
				}
				intFinish++;
			}

			strReturn += "</tr>";
			return strReturn;
		}

		//Build the control
		protected override void CreateChildControls() 
		{
			int intColRows = (m_items.Count / m_intTabsAcross) + 1;
			int intPositionRendered = 0;
			int intStartPosition = 0;

			order();

			this.Controls.Clear();

			this.Controls.Add(new LiteralControl("<table cellpadding=\"2\" cellspacing=\"1\" border=\"0\">"));

			for (int i=1; i <= intColRows; i++) 
			{
				if ((m_strTopImage.Length > 0) || (m_strSelTopImage.Length > 0))
				{
					this.Controls.Add(new LiteralControl(TopRow(intStartPosition, ref intPositionRendered, m_intSelTab)));
				}
				MiddleRow(intStartPosition, ref intPositionRendered, m_intSelTab);
				if ((m_strBottomImage.Length > 0) || (m_strSelBottomImage.Length > 0)) 
				{
					this.Controls.Add(new LiteralControl(BottomRow(intStartPosition, ref intPositionRendered, m_intSelTab)));
				}
				intStartPosition = intPositionRendered;
			}

			this.Controls.Add(new LiteralControl("</table>"));

		}

		//Saves the View State
		protected override object SaveViewState() 
		{
			object[] allStates = new object[2];
			allStates[0] = base.SaveViewState();
			allStates[1] = m_intSelTab;
			return allStates;
		}
		//Loads View State Info																																																		  'Load Saved State Values
		protected override void LoadViewState(object savedState) 
		{
			if (savedState != null)
			{
				object[] myState = (object[])savedState;
				if (myState[0] != null) 
				{
					base.LoadViewState(myState[0]);
				}
				if (myState[1] != null) 
				{
					m_intSelTab = Convert.ToInt32(myState[1]);
				}
			}
		}
		#endregion

	}

	#endregion
}

