#region Licence
// Copyright (c) 2007 James Gregory (james@jagregory.com)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of James Gregory nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

using System.Web.UI.WebControls;

namespace JAGregory.Controls
{
	public interface IDeleGrid
	{
		event PageDataRequestEventHandler PageDataRequest;
		event TotalRecordCountRequestEventHandler TotalRecordCountRequest;

		bool AlwaysRequestTotal { get; set; }

		/// <summary>
		/// Gets or sets the field currently used for sorting.
		/// </summary>
		/// <remarks>
		/// Persisted in ViewState for binding use.
		/// </remarks>
		string SortingField { get; set; }

		/// <summary>
		/// Gets or sets the sorting direction currently used for sorting.
		/// </summary>
		/// <remarks>
		/// Persisted in ViewState for binding use.
		/// </remarks>
		SortDirection SortingDirection { get; set; }

		/// <summary>
		/// Gets or sets the current page index for the grid.
		/// </summary>
		int PageIndex { get; set; }

		void DataBind();
	}
}