using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Net;
using System.Xml;

[assembly:TagPrefix("WebControlXml","XmlEx")]
namespace WebControlXml
{
	/// <summary>
	/// Contrle ASP:XML tendu.
	/// </summary>
	[ToolboxData("<{0}:XmlEx runat=server></{0}:XmlEx>")]
	public class XmlEx : System.Web.UI.WebControls.Xml
	{
		private string documentUrl;

		[Category("Behavior"), DefaultValue("")]
		public string DocumentUrl 
		{
			get
			{
				return documentUrl;
			}

			set
			{
				documentUrl = value;

				WebRequest req = WebRequest.Create(documentUrl);
				WebResponse resp = req.GetResponse();

				XmlTextReader reader = new XmlTextReader(resp.GetResponseStream());

				this.Document = new XmlDocument();
				this.Document.Load(reader);
			}
		}
	}
}
