using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            gvHotmail.DataSource = GetDataTable();
            gvHotmail.DataBind();
        }
    }

    protected DataTable GetDataTable()
    {
        DataTable dTable = new DataTable();
        DataRow dRow = null;
        Random rnd = new Random();
        dTable.Columns.Add("n");
        dTable.Columns.Add("nn");

        for (int n = 0; n < 10; ++n)
        {
            dRow = dTable.NewRow();

            dRow["n"] = n + ".";
            dRow["nn"] = n * n + "";

            dTable.Rows.Add(dRow);
            dTable.AcceptChanges();
        }

        return dTable;
    }
    protected void gvHotmail_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow && (e.Row.RowState == DataControlRowState.Normal || e.Row.RowState == DataControlRowState.Alternate))
        {
            HtmlInputCheckBox chkBxMail = (HtmlInputCheckBox)e.Row.Cells[1].FindControl("chkBxMail");
            Image imgMail = (Image)e.Row.Cells[1].FindControl("imgMail");

            e.Row.Attributes["onmouseover"] = string.Format("javascript:ItemMouseOver(this,'{0}','{1}');", chkBxMail.ClientID, imgMail.ClientID);
            e.Row.Attributes["onmouseout"] = string.Format("javascript:ItemMouseOut(this,'{0}','{1}');", chkBxMail.ClientID, imgMail.ClientID);
            chkBxMail.Attributes["style"] = "display:none;";
        }
    }
}
