using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace AddCssToDataGridSample
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DataGrid dgPersons;
		protected System.Web.UI.WebControls.CheckBox chkAddCSS;
		protected System.Web.UI.WebControls.CheckBox chkAddJavascriptMouseovers;
		protected System.Web.UI.WebControls.CheckBox chkAddDeleteConfirmation;
		protected System.Web.UI.WebControls.Button btnReloadData;
		protected System.Web.UI.WebControls.Label Label2;
		protected System.Web.UI.WebControls.Label Label3;
	
		//the dataset containing the table with our persons
		protected dsPersons persons;

		private void Page_Load(object sender, System.EventArgs e)
		{
			//load the data to display
			LoadData();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.dgPersons.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.dgPersons_DeleteCommand);
			this.chkAddJavascriptMouseovers.CheckedChanged += new System.EventHandler(this.chkAddJavascriptMouseovers_CheckedChanged);
			this.chkAddCSS.CheckedChanged += new System.EventHandler(this.chkAddCSS_CheckedChanged);
			this.btnReloadData.Click += new System.EventHandler(this.btnReloadData_Click);
			this.Load += new System.EventHandler(this.Page_Load);
			this.PreRender += new System.EventHandler(this.WebForm1_PreRender);

		}
		#endregion

		

		// This method runs right before the page
		// and all its controls are converted to HTML
		// and sent to the client's browser.
		// This is the place to databind,
		// and therefore we do all the adding of 
		// attributes, etc. here.
		private void WebForm1_PreRender(object sender, System.EventArgs e)
		{
			//if the checkbox is checked
			//then we add CSS class names
			//so the CSS file's contents get to work
			if (chkAddCSS.Checked)
				DataGridHelper.AddCssToDataGrid(dgPersons);

			//set the datagrid's datasource to the
			//table containing our people
			dgPersons.DataSource = persons.person;
			//bind the data
			dgPersons.DataBind();

			//if the user wants to add deleteconfirmation
			if(chkAddDeleteConfirmation.Checked)
			{
				//then we add a confirmation dialog to the
				//linkbutton in row 3.
				//Remember that we've hidden row zero 
				//that's why the Delete row is number three.
				DataGridHelper.AddConfirm(dgPersons, 3,"Do you wish to delete this person?");
			}
			//if the user wants to add mouseovers
			if(chkAddJavascriptMouseovers.Checked)
			{
				//add the mouseover and mouseout attributes
				//and link them to to the javascript 
				//function "changeStyle()"
				DataGridHelper.AddAttributesToCells(dgPersons,"onMouseOver", "javascript:changeStyle(event);");
				DataGridHelper.AddAttributesToCells(dgPersons,"onMouseOut", "javascript:changeStyle(event);");
			}
			//make sure all columns in the DataGrid 
			//are one third of the width
			DataGridHelper.AddAttributesToCells(dgPersons,"width", "33%");
		}

		private void dgPersons_DeleteCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			//we find the id of this row 
			//by looking in the hidden first colum
			int id = int.Parse(e.Item.Cells[0].Text);
			//this person we look up in the Table,
			//and mark the row for deletion
			persons.person.FindByid(id).Delete();
		}

		
		private void btnReloadData_Click(object sender, System.EventArgs e)
		{
			//empties the Session state of data
			Session["persons"] = null;
			//reloads the dataset from disk
			LoadData();
		}

		public void LoadData()
		{
			//if we don't have any data in Session state
			if(Session["persons"]== null)
			{
				//find the full path to the xml file
				string path = Server.MapPath("persons.xml");
				//create a new, empty dataset
				persons = new dsPersons();
				//fill it with data from the file
				persons.ReadXml(path);
				//save it in Session state
				Session["persons"] = persons;
			}
			//in all cases, we can now retrieve 
			//the dataset from Session state
			persons = (dsPersons) Session["persons"];
		}

	
		private void chkAddJavascriptMouseovers_CheckedChanged(object sender, System.EventArgs e)
		{
			//make sure that CSS classnames are added to the cells
			//if we try to add javascript to the hoverfunctions
			//because the javascript functions we add need the
			//css classes
			if(chkAddJavascriptMouseovers.Checked)
				chkAddCSS.Checked = true;
		}

		private void chkAddCSS_CheckedChanged(object sender, System.EventArgs e)
		{
			//if we've just unchecked the checkbox for CSS..
			if(!chkAddCSS.Checked)
				//then we also need to remove the javascript Mouseovers 
				//(see the method above for explanation)
				chkAddJavascriptMouseovers.Checked = false;
		}	
	}
}