using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace AutoReports
{
	/// <summary>
	/// Summary description for GenerateReport.
	/// </summary>
	public class GenerateReport : System.Web.UI.Page
	{
		private string connectionstring = "server=W15MTC12j052;database=Northwind;uid=onlineuser;password=password;";
		private string ViewOrTableName = "Invoices";
		private void Page_Load(object sender, System.EventArgs e)
		{
			if ( Page.IsPostBack == false )
			{
				string query = "SELECT Distinct * FROM " + ViewOrTableName;
				if ( Request.QueryString["Data"] == null )
				{
					query = "SELECT Distinct * FROM " + ViewOrTableName;
				}
				else
				{
					String[] DataArray = Request.QueryString["Data"].ToString().Split(';');
					query = "";
					foreach ( string cl in DataArray)
					{
						if ( cl.Trim().Length > 0 )
						{
							if ( query.Length == 0 )
							{
								query = " " + cl + " ";
							}
							else
							{
								query = query + "," + cl + " ";
							}
						}
					}
					query = "Select distinct " + query + " FROM " + ViewOrTableName;
				}
				DataSet ds = new DataSet();
				ds = RunQuery( query );
				if ( ds != null && ds.Tables.Count > 0 && ds.Tables[0].Rows.Count > 0 )
				{
					DataGrid NewDg = new DataGrid();
					NewDg.AutoGenerateColumns = true;
					NewDg.Width = Unit.Percentage(80.00);
					NewDg.DataSource = ds;
					NewDg.DataBind();
				
					SetProps(NewDg);

					System.IO.StringWriter sw = new System.IO.StringWriter();
					System.Web.UI.HtmlTextWriter htw = new System.Web.UI.HtmlTextWriter(sw);
					NewDg.RenderControl( htw );	

					Response.Write( sw.ToString() );
				}
			}
		}

		private DataSet RunQuery(string QueryString)
		{
			System.Data.SqlClient.SqlConnection conn = new System.Data.SqlClient.SqlConnection();

			try
			{
				conn.ConnectionString = connectionstring;
				if ( conn.State == System.Data.ConnectionState.Closed )
				{
					conn.Open();
				}
				
				System.Data.SqlClient.SqlDataAdapter adapter = new System.Data.SqlClient.SqlDataAdapter( QueryString, conn);
				DataSet ds = new DataSet();
				adapter.Fill( ds );
				return ds;
			}
			catch(Exception ex1)
			{
				Response.Write("An Error has occurred.<BR />");
				Response.Write(ex1.Message.ToString());
				Response.End();
				//This line below will never execute.
				return null;
			}
			finally
			{
				if ( conn.State == System.Data.ConnectionState.Open )
				{
					conn.Close();
				}
			}
		}


		public void SetProps(System.Web.UI.WebControls.DataGrid DG)
		{
			/****************************************************************************/
			DG.Font.Size = 8;
			DG.Font.Bold = false;
			DG.Font.Name = "tahoma";

			/*******************************Professional 2**********************************/
			//Border Props 
			DG.GridLines = GridLines.Both;
			DG.CellPadding = 3;
			DG.CellSpacing = 0;
			DG.BorderColor = System.Drawing.Color.FromName("#CCCCCC");
			DG.BorderWidth = System.Web.UI.WebControls.Unit.Pixel(1);

			
			//Header Props
			DG.HeaderStyle.BackColor = System.Drawing.Color.SteelBlue;
			DG.HeaderStyle.ForeColor = System.Drawing.Color.White;
			DG.HeaderStyle.Font.Bold = true;
			DG.HeaderStyle.Font.Size = 8;
			DG.HeaderStyle.Font.Name = "tahoma";

			DG.ItemStyle.BackColor = System.Drawing.Color.LightSteelBlue;

		}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
