namespace AutoReports.Controls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	/// <summary>
	///		Generates Reports on the fly.
	/// </summary>
	public class ReportsControl1 : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Label LabelInstructionsTitle;
		protected System.Web.UI.WebControls.DropDownList DDLColumnName;
		protected System.Web.UI.WebControls.Label LabelColumnName;
		protected System.Web.UI.WebControls.TextBox TBColumnTitle;
		protected System.Web.UI.WebControls.Label LabelColumnTitle;
		protected System.Web.UI.WebControls.Button BtnAdd;
		protected System.Web.UI.WebControls.ListBox LBAllColumns;
		protected System.Web.UI.WebControls.TextBox TBAllColumns;
		protected System.Web.UI.WebControls.Image Image1;
		protected System.Web.UI.WebControls.Label LabelJSError;
		protected System.Web.UI.WebControls.Button BtnGenerateReport;
		protected System.Web.UI.HtmlControls.HtmlGenericControl DivReports;
		protected System.Web.UI.HtmlControls.HtmlGenericControl DivReportsHeader;
		
		private string connectionstring = "server=SERVERNAME;database=Northwind;uid=USERID;password=PASSWORD;";
		private string ViewOrTableName = "Invoices";

		private void Page_Load(object sender, System.EventArgs e)
		{
			if ( !Page.IsPostBack )
			{
				//First time page load.
				//Load all the colum names from teh Northwind database
				BtnGenerateReport.Style["display"] = "none";
				BtnGenerateReport.Style["visibility"] = "visible";
				LoadDropDownListWithColumNames();
				
				this.BtnAdd.Attributes["onclick"] = "GetDropDownListValue('" + this.DDLColumnName.ClientID + "','" + this.LabelJSError.ClientID + "','" + this.TBColumnTitle.ClientID + "','" + this.LBAllColumns.ClientID + "','" + this.TBAllColumns.ClientID + "','" + this.BtnGenerateReport.ClientID + "'); return false;";
				this.BtnGenerateReport.Attributes["onclick"] = "GetReport('" + this.DivReports.ClientID + "','" + this.TBAllColumns.ClientID + "'); return false;";
				this.DDLColumnName.Attributes["onchange"] = "DropDownListOnChange('" + this.DDLColumnName.ClientID + "','" + this.TBColumnTitle.ClientID + "');";
			}
		}

		private void LoadDropDownListWithColumNames()
		{
			string query = "SELECT DISTINCT TOP 1 * FROM " + ViewOrTableName;
			FillDropDownList( this.DDLColumnName, query );
		}

		public void FillDropDownList(DropDownList DDL, string query)
		{
			DDL.Items.Clear();
			DDL.Items.Add("Select");

			System.Data.DataSet ds = new DataSet();
			ds = this.RunQuery(query);
			if ( ds == null || ds.Tables.Count == 0)
			{
				return;
			}
			else
			{
				//Add each column to the list
				foreach ( DataColumn dc in ds.Tables[0].Columns )
				{
					ListItem tmp = new ListItem( dc.ColumnName, dc.ColumnName );
					DDL.Items.Add(tmp);
				}
			}
		}

		private DataSet RunQuery(string QueryString)
		{
			System.Data.SqlClient.SqlConnection conn = new System.Data.SqlClient.SqlConnection();

			try
			{
				conn.ConnectionString = connectionstring;
				if ( conn.State == System.Data.ConnectionState.Closed )
				{
					conn.Open();
				}
				
				System.Data.SqlClient.SqlDataAdapter adapter = new System.Data.SqlClient.SqlDataAdapter( QueryString, conn);
				DataSet ds = new DataSet();
				adapter.Fill( ds );
				return ds;
			}
			catch(Exception ex1)
			{
				Response.Write("An Error has occurred.<BR />");
				Response.Write(ex1.Message.ToString());
				Response.End();
				//This line below will never execute.
				return null;
			}
			finally
			{
				if ( conn.State == System.Data.ConnectionState.Open )
				{
					conn.Close();
				}
			}
		}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
