using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.ComponentModel;
using System.Collections;
// Needed for ambiguous reference from System.Web.UI.AttributeCollection &
// System.ComponentModel.AttributeCollection
using AttributeCollection = System.ComponentModel.AttributeCollection;
using System.Globalization;
//using System.Runtime.InteropServices;
using Altinoren.HTMLControls;

namespace Altinoren.HTMLControls.Design
{

	public class ShowHideButtonDesigner : ControlDesigner 
	{
		private ShowHideButton ctl;

		public override void Initialize(IComponent component)
		{
		       ctl = (ShowHideButton)component;
		       base.Initialize(component);
	    }

		public string ControlToShowHide
		{
			get {return ctl.ControlToShowHide;}
			set
			{
				ctl.ControlToShowHide = value;
		    }
		}

		// Modifies the set of properties that the designer exposes
		// through a TypeDescriptor object.
		protected override void PreFilterProperties(IDictionary properties)
		{
			base.PreFilterProperties(properties);

			//MyControlList property converter
			PropertyDescriptor myProp = (PropertyDescriptor)properties["ControlToShowHide"];
			if(myProp!=null)
			{
				//Get the array of attributes to display in the property window
				myProp = TypeDescriptor.CreateProperty(this.GetType(), myProp,new Attribute[] {new TypeConverterAttribute(typeof(ControlListConverter))});
				properties["ControlToShowHide"] = myProp;
			}
		}

		public override string GetDesignTimeHtml() 
		{
			// Component is the control instance, defined in the base
			// designer
			ShowHideButton ctl = (ShowHideButton) Component;

			if (ctl.Text != "" && ctl.Text != null)
			{
				Button placeholderButton = new Button();
				
				StringWriter sw = new StringWriter();
				HtmlTextWriter tw = new HtmlTextWriter(sw);

				// put control text into the link's Text
				placeholderButton.Text = ctl.Text;
				placeholderButton.RenderControl(tw);

				return sw.ToString();
			}
			else
				return GetEmptyDesignTimeHtml();

		}
	}

	//[System.Security.Permissions.SecurityPermission(System.Security.Permissions.SecurityAction.Demand, Flags=System.Security.Permissions.SecurityPermissionFlag.UnmanagedCode)]
	public class ControlListConverter : TypeConverter
	{
		public ControlListConverter()
		{
		}

		// Returns whether this converter can convert an object of one type to the type of this converter.
		// We are only support string types.
		public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
		{
			if (sourceType == typeof(string))
			{
				return true;
			}

			return false;
		}
		// Converts the given value to the type of this converter.
		public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value)
		{
			if (value == null)
		    {
				return String.Empty;
			}
			else if (value.GetType() == typeof(string))
			{
				return (string)value;
			}

			throw GetConvertFromException(value);
		}

		// Returns a collection of standard values for the data type this type converter is designed for.
		public override StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
		{
			string[] names = null;

			if (context != null)
			{
				IComponent component = context.Instance as IComponent;

				if (component != null)
				{
					//Get a reference to the Page and get a list of controls on it.
					//Then return a string array that contain the names of the controls.
					//The items of this array will be listed in the dropdown in properties editor.

					//BUGFIX (v 0.8.5.*): If the parent is a user control, casting to the page object fails.
					//Go through the controls collection instead.
					ControlCollection myControls = ((Altinoren.HTMLControls.ShowHideButton)(component)).Parent.Controls;
					ArrayList ctlArray = new ArrayList();

					if (myControls.Count != 0)
					{
						//Get ID of this control. We won't show it in the available selections.
						String selfID = ((Altinoren.HTMLControls.ShowHideButton)(component)).ID;
						IEnumerator myEnumerator = myControls.GetEnumerator();
						while(myEnumerator.MoveNext())
						{
							Control myControl = (Control) myEnumerator.Current;
							if (myControl.ID != selfID)
								ctlArray.Add( myControl.ID);
						}

						names = (string[])(ctlArray.ToArray(System.Type.GetType("System.String")));
					}
				} //if (component != null)

				if (names == null)
				{
					names = new string[0];
				}

				Array.Sort(names);
			} //if (context != null)
			return new StandardValuesCollection(names);
		}

		// Returns whether the collection of standard values returned from GetStandardValues is an exclusive list.
		public override bool GetStandardValuesExclusive(ITypeDescriptorContext context)
		{
			return false;
		}

		// Returns whether this object supports a standard set of values that can be picked from a list.
		public override bool GetStandardValuesSupported(ITypeDescriptorContext context)
		{
			if (context != null)
			{
				if (context.Instance is IComponent)
				{
					// We only support the dropdown in single-select mode.
					return true;
				}
			}
			return false;
		}
	}
}
