using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;

namespace Altinoren.HTMLControls.BrowserWindow
{

	public class BWImageButtonDesigner : System.Web.UI.Design.ControlDesigner 
	{
		public override string GetDesignTimeHtml() 
		{
			// Component is the control instance, defined in the base
			// designer
			BWImageButton ctl = (BWImageButton) Component;

			if (ctl.ImageUrl != "" && ctl.ImageUrl != null)
			{
				System.Web.UI.WebControls.ImageButton placeholderImage = new System.Web.UI.WebControls.ImageButton();
				
				StringWriter sw = new StringWriter();
				HtmlTextWriter tw = new HtmlTextWriter(sw);

				// assign control's properties into the image's properties
				placeholderImage.AlternateText = ctl.AlternateText;
				placeholderImage.ImageUrl = ctl.ImageUrl;
				placeholderImage.Attributes.Add("onclick", ctl.GetAttributes());
				placeholderImage.RenderControl(tw);

				return sw.ToString();
			}
			else
				return GetEmptyDesignTimeHtml();

		}
	}
}
