using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;

namespace Altinoren.HTMLControls.BrowserWindow
{

	public class BWHyperLinkDesigner : System.Web.UI.Design.ControlDesigner 
	{
		public override string GetDesignTimeHtml() 
		{
			// Component is the control instance, defined in the base
			// designer
			BWHyperLink ctl = (BWHyperLink) Component;

			if (ctl.Text != "" && ctl.Text != null)
			{
				System.Web.UI.WebControls.HyperLink placeholderLink = new System.Web.UI.WebControls.HyperLink();
				
				StringWriter sw = new StringWriter();
				HtmlTextWriter tw = new HtmlTextWriter(sw);

				// put control text into the link's Text
				placeholderLink.Text = ctl.Text;
				placeholderLink.NavigateUrl = ctl.NavigateUrl;
				placeholderLink.Attributes.Add("onclick", ctl.GetAttributes());
				placeholderLink.RenderControl(tw);

				return sw.ToString();
			}
			else
				return GetEmptyDesignTimeHtml();

		}
	}
}
