using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace DemoPopCalendar
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public partial class DemoPopCalendar : System.Web.UI.Page
	{
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here

			// Set the location of the JavaScripts and CSS for the RJS.PopCalendar
			// RJS.Web.WebControl.PopCalendar.JavaScriptCustomPath = "http://MyServer/MyCalendarScripts/";
			lblSalvar.Text = "";
			SpecialDays.AddHolidays(PopCalendar3);
			SpecialDays.AddSpecialDays(PopCalendar3);
			if (!Page.IsPostBack)
			{
				PopCalendar3.DateValue = DateTime.Today;
				PopCalendar4.DateValue = DateTime.Today.AddDays(-7);
				lblFecha.Text = PopCalendar4.SelectedDate;
			}
			if (CheckBox1.Checked)
			{
				PopCalendar3.CssClass = "Small";
			}
			PopCalendar3.ShowBlankFieldText = CheckBox6.Checked;
			if (CheckBox7.Checked)
			{
				PopCalendar4.WeekNumberFormula = RJS.Web.WebControl.PopCalendar.WeekNumberFormulaEnum.AlwaysJanuary1IsWeek1; 
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.PopCalendar4.SelectionChanged += new RJS.Web.WebControl.PopCalendar.SelectionChangedEventHandler(this.PopCalendar4_SelectionChanged);

		}
		#endregion

		protected void btnSalvar_Click(object sender, System.EventArgs e)
		{
			if (Page.IsValid)
			{
				//Salvar Informacin
				lblSalvar.Text = "Pgina Vlida";
			}
			else
			{
				lblSalvar.Text = "Pgina Invlida";
			}
		}

		private void PopCalendar4_SelectionChanged(object sender, System.EventArgs e)
		{
			if (PopCalendar4.SelectedDate == "")
			{
				lblFecha.Text = "&nbsp;";
				lblSalvar.Text = "Fecha Nula";
			}
			else
			{
				lblFecha.Text = PopCalendar4.SelectedDate;
				lblSalvar.Text = PopCalendar4.DateValue.ToString("D", new System.Globalization.CultureInfo("es-PA"));
			}
		}

		protected void CheckBoxCalendar_CheckedChanged(object sender, System.EventArgs e)
		{
			this.Page.Validate();
			HtmlForm _Form = (HtmlForm) CheckBox2.Parent;
			for (int i = 0; i < _Form.Controls.Count; i++)
			{
				if (_Form.Controls[i] is RJS.Web.WebControl.PopCalendar)
				{
					RJS.Web.WebControl.PopCalendar _Calendar = 
						(RJS.Web.WebControl.PopCalendar) _Form.Controls[i];
					_Calendar.Visible = !CheckBox2.Checked;
					_Calendar.Enabled = !CheckBox3.Checked;
				}
			}
		}

		protected void CheckBoxTextBox_CheckedChanged(object sender, System.EventArgs e)
		{
			this.Page.Validate();
			HtmlForm _Form = (HtmlForm) CheckBox4.Parent;
			for (int i = 0; i < _Form.Controls.Count; i++)
			{
				if (_Form.Controls[i] is TextBox)
				{
					TextBox _TextBox = (TextBox) _Form.Controls[i];
					if(_TextBox.ID != "txtNoSem")
					{
						_TextBox.Visible = !CheckBox4.Checked;
						_TextBox.Enabled = !CheckBox5.Checked;
						_TextBox.ReadOnly = CheckBox6.Checked;
					}
				}
			}
		}

	}
}
