using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace DemoPopCalendar
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class DemoPopCalendar : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblFrom;
		protected System.Web.UI.WebControls.TextBox txtFrom;
		protected RJS.Web.WebControl.PopCalendar PopCalendar1;
		protected RJS.Web.WebControl.PopCalendarMessageContainer PopCalendarMessageContainer1;
		protected System.Web.UI.WebControls.Label lblTo;
		protected System.Web.UI.WebControls.TextBox txtTo;
		protected RJS.Web.WebControl.PopCalendar PopCalendar2;
		protected RJS.Web.WebControl.PopCalendarMessageContainer PopCalendarMessageContainer2;
		protected System.Web.UI.WebControls.Label lblRange;
		protected System.Web.UI.WebControls.TextBox txtRange;
		protected RJS.Web.WebControl.PopCalendar PopCalendar3;
		protected System.Web.UI.WebControls.CheckBox CheckBox1;
		protected System.Web.UI.WebControls.DropDownList DropDownList1;
		protected System.Web.UI.WebControls.CheckBox CheckBox2;
		protected System.Web.UI.WebControls.CheckBox CheckBox3;
		protected System.Web.UI.WebControls.CheckBox CheckBox4;
		protected System.Web.UI.WebControls.CheckBox CheckBox5;
		protected System.Web.UI.WebControls.CheckBox CheckBox6;
		protected System.Web.UI.WebControls.CheckBox CheckBox7;
		protected System.Web.UI.WebControls.Label labelFecha;
		protected System.Web.UI.WebControls.Label lblFecha;
		protected RJS.Web.WebControl.PopCalendar PopCalendar4;
		protected System.Web.UI.WebControls.Button btnSalvar;
		protected System.Web.UI.WebControls.Label lblSalvar;
		protected System.Web.UI.WebControls.Label lblWeek;
		protected System.Web.UI.WebControls.TextBox txtNoSem;
		protected System.Web.UI.WebControls.ListBox ListBox1;
		protected System.Web.UI.WebControls.ValidationSummary ValidationSummary1;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here

			// Set the location of the JavaScripts and CSS for the RJS.PopCalendar
			// RJS.Web.WebControl.PopCalendar.JavaScriptCustomPath = "http://MyServer/MyCalendarScripts/";
			// Fix for Mozilla Browsers
			if (this.Context.Request.Browser.Browser.ToUpper().IndexOf("IE") == -1)
			{
				DropDownList1.Style.Add("Width", DropDownList1.Width.ToString());
				ListBox1.Style.Add("Width", ListBox1.Width.ToString());
				lblFecha.Style.Add("Width", lblFecha.Width.ToString());
				lblFecha.Style.Add("Border-Style", lblFecha.BorderStyle.ToString());
				lblFecha.Style.Add("Border-Color", System.Drawing.ColorTranslator.ToHtml(lblFecha.BorderColor));
				lblFecha.Style.Add("Border-Width", lblFecha.BorderWidth.ToString());
				txtNoSem.Style.Add("Width", txtNoSem.Width.ToString());
			}
			lblSalvar.Text = "";
			SpecialDays.AddHolidays(PopCalendar3);
			SpecialDays.AddSpecialDays(PopCalendar3);
			if (!Page.IsPostBack)
			{
				PopCalendar3.DateValue = DateTime.Today;
				PopCalendar4.DateValue = DateTime.Today.AddDays(-7);
				lblFecha.Text = PopCalendar4.SelectedDate;
			}
			if (CheckBox1.Checked)
			{
				PopCalendar3.CssClass = "Small";
			}
			PopCalendar3.ShowBlankFieldText = CheckBox6.Checked;
			if (CheckBox7.Checked)
			{
				PopCalendar4.WeekNumberFormula = RJS.Web.WebControl.PopCalendar.WeekNumberFormulaEnum.AlwaysJanuary1IsWeek1; 
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.CheckBox2.CheckedChanged += new System.EventHandler(this.CheckBoxCalendar_CheckedChanged);
			this.CheckBox3.CheckedChanged += new System.EventHandler(this.CheckBoxCalendar_CheckedChanged);
			this.CheckBox4.CheckedChanged += new System.EventHandler(this.CheckBoxTextBox_CheckedChanged);
			this.CheckBox5.CheckedChanged += new System.EventHandler(this.CheckBoxTextBox_CheckedChanged);
			this.CheckBox6.CheckedChanged += new System.EventHandler(this.CheckBoxTextBox_CheckedChanged);
			this.PopCalendar4.SelectionChanged += new RJS.Web.WebControl.PopCalendar.SelectionChangedEventHandler(this.PopCalendar4_SelectionChanged);
			this.btnSalvar.Click += new System.EventHandler(this.btnSalvar_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnSalvar_Click(object sender, System.EventArgs e)
		{
			if (Page.IsValid)
			{
				//Salvar Informacin
				lblSalvar.Text = "Pgina Vlida";
			}
			else
			{
				lblSalvar.Text = "Pgina Invlida";
			}
		}

		private void PopCalendar4_SelectionChanged(object sender, System.EventArgs e)
		{
			if (PopCalendar4.SelectedDate == "")
			{
				lblFecha.Text = "&nbsp;";
				lblSalvar.Text = "Fecha Nula";
			}
			else
			{
				lblFecha.Text = PopCalendar4.SelectedDate;
				lblSalvar.Text = PopCalendar4.DateValue.ToString("D", new System.Globalization.CultureInfo("es-PA"));
			}
		}

		private void CheckBoxCalendar_CheckedChanged(object sender, System.EventArgs e)
		{
			this.Page.Validate();
			HtmlForm _Form = (HtmlForm) CheckBox2.Parent;
			for (int i = 0; i < _Form.Controls.Count; i++)
			{
				if (_Form.Controls[i] is RJS.Web.WebControl.PopCalendar)
				{
					RJS.Web.WebControl.PopCalendar _Calendar = 
						(RJS.Web.WebControl.PopCalendar) _Form.Controls[i];
					_Calendar.Visible = !CheckBox2.Checked;
					_Calendar.Enabled = !CheckBox3.Checked;
				}
			}
		}

		private void CheckBoxTextBox_CheckedChanged(object sender, System.EventArgs e)
		{
			this.Page.Validate();
			HtmlForm _Form = (HtmlForm) CheckBox4.Parent;
			for (int i = 0; i < _Form.Controls.Count; i++)
			{
				if (_Form.Controls[i] is TextBox)
				{
					TextBox _TextBox = (TextBox) _Form.Controls[i];
					if(_TextBox.ID != "txtNoSem")
					{
						_TextBox.Visible = !CheckBox4.Checked;
						_TextBox.Enabled = !CheckBox5.Checked;
						_TextBox.ReadOnly = CheckBox6.Checked;
					}
				}
			}
		}
	}
}
