using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Utilities
{
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:GridViewRowSelector runat=\"server\"></{0}:GridViewRowSelector>")]
    public class GridViewRowSelector : RadioButton
    {
        protected override void Render(HtmlTextWriter writer)
        {
            GridViewRow row = (GridViewRow)this.NamingContainer;
            int currentIndex = row.RowIndex;
            GridView grid = (GridView)row.NamingContainer;
            this.Checked = (grid.SelectedIndex == currentIndex);
            this.Attributes.Add("onClick", "javascript:" + Page.ClientScript.GetPostBackEventReference(grid, "Select$" + currentIndex.ToString(), true));
            base.Render(writer);
        }

    }


}
